/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.aws.utils.DynamoTableUtils;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.exception.HoodieLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@NotThreadSafe
public class DynamoDBBasedLockProvider
implements LockProvider<LockItem> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDBBasedLockProvider.class);
    private static final String DYNAMODB_ATTRIBUTE_NAME = "key";
    private final AmazonDynamoDBLockClient client;
    private final String tableName;
    private final String dynamoDBPartitionKey;
    protected final DynamoDbBasedLockConfig dynamoDBLockConfiguration;
    private volatile LockItem lock;

    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, Configuration conf) {
        this(lockConfiguration, conf, null);
    }

    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, Configuration conf, DynamoDbClient dynamoDB) {
        this.dynamoDBLockConfiguration = DynamoDbBasedLockConfig.newBuilder().fromProperties(lockConfiguration.getConfig()).build();
        this.tableName = this.dynamoDBLockConfiguration.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_NAME);
        this.dynamoDBPartitionKey = this.dynamoDBLockConfiguration.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY);
        long leaseDuration = this.dynamoDBLockConfiguration.getInt(DynamoDbBasedLockConfig.LOCK_ACQUIRE_WAIT_TIMEOUT_MS_PROP_KEY).intValue();
        if (dynamoDB == null) {
            dynamoDB = this.getDynamoDBClient();
        }
        this.client = new AmazonDynamoDBLockClient(AmazonDynamoDBLockClientOptions.builder((DynamoDbClient)dynamoDB, (String)this.tableName).withTimeUnit(TimeUnit.MILLISECONDS).withLeaseDuration(Long.valueOf(leaseDuration)).withHeartbeatPeriod(Long.valueOf(leaseDuration / 3L)).withCreateHeartbeatBackgroundThread(Boolean.valueOf(true)).build());
        if (!this.client.lockTableExists()) {
            this.createLockTableInDynamoDB(dynamoDB, this.tableName);
        }
    }

    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info(this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.lock = this.client.acquireLock(AcquireLockOptions.builder((String)this.dynamoDBPartitionKey).withAdditionalTimeToWaitForLock(Long.valueOf(time)).withTimeUnit(TimeUnit.MILLISECONDS).build());
            LOG.info(this.generateLogStatement(LockState.ACQUIRED, this.generateLogSuffixString()));
        }
        catch (InterruptedException e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), (Throwable)e);
        }
        catch (LockNotGrantedException e) {
            return false;
        }
        return this.lock != null && !this.lock.isExpired();
    }

    public void unlock() {
        try {
            LOG.info(this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            if (this.lock == null) {
                return;
            }
            if (!this.client.releaseLock(this.lock)) {
                LOG.warn("The lock has already been stolen");
            }
            this.lock = null;
            LOG.info(this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), (Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.lock != null) {
                if (!this.client.releaseLock(this.lock)) {
                    LOG.warn("The lock has already been stolen");
                }
                this.lock = null;
            }
            this.client.close();
        }
        catch (Exception e) {
            LOG.error(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    public LockItem getLock() {
        return this.lock;
    }

    private DynamoDbClient getDynamoDBClient() {
        String endpointURL;
        String region = this.dynamoDBLockConfiguration.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_REGION);
        String string = endpointURL = this.dynamoDBLockConfiguration.contains(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL.key()) != false ? this.dynamoDBLockConfiguration.getString(DynamoDbBasedLockConfig.DYNAMODB_ENDPOINT_URL) : DynamoDbClient.serviceMetadata().endpointFor(Region.of((String)region)).toString();
        if (!endpointURL.startsWith("https://") && !endpointURL.startsWith("http://")) {
            endpointURL = "https://" + endpointURL;
        }
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().endpointOverride(URI.create(endpointURL))).credentialsProvider(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider((Properties)this.dynamoDBLockConfiguration.getProps()))).build();
    }

    private void createLockTableInDynamoDB(DynamoDbClient dynamoDB, String tableName) {
        String billingMode = this.dynamoDBLockConfiguration.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_BILLING_MODE);
        KeySchemaElement partitionKeyElement = (KeySchemaElement)KeySchemaElement.builder().attributeName(DYNAMODB_ATTRIBUTE_NAME).keyType(KeyType.HASH).build();
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(partitionKeyElement);
        ArrayList<Object> attributeDefinitions = new ArrayList<Object>();
        attributeDefinitions.add(AttributeDefinition.builder().attributeName(DYNAMODB_ATTRIBUTE_NAME).attributeType(ScalarAttributeType.S).build());
        CreateTableRequest.Builder createTableRequestBuilder = CreateTableRequest.builder();
        if (billingMode.equals(BillingMode.PROVISIONED.name())) {
            createTableRequestBuilder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.dynamoDBLockConfiguration.getLong(DynamoDbBasedLockConfig.DYNAMODB_LOCK_READ_CAPACITY)).writeCapacityUnits(this.dynamoDBLockConfiguration.getLong(DynamoDbBasedLockConfig.DYNAMODB_LOCK_WRITE_CAPACITY)).build());
        }
        createTableRequestBuilder.tableName(tableName).keySchema(keySchema).attributeDefinitions(attributeDefinitions).billingMode(billingMode);
        dynamoDB.createTable((CreateTableRequest)createTableRequestBuilder.build());
        LOG.info("Creating dynamoDB table " + tableName + ", waiting for table to be active");
        try {
            DynamoTableUtils.waitUntilActive(dynamoDB, tableName, this.dynamoDBLockConfiguration.getInt(DynamoDbBasedLockConfig.DYNAMODB_LOCK_TABLE_CREATION_TIMEOUT), 20000);
        }
        catch (DynamoTableUtils.TableNeverTransitionedToStateException e) {
            throw new HoodieLockException("Created dynamoDB table never transits to active", (Throwable)((Object)e));
        }
        catch (InterruptedException e) {
            throw new HoodieLockException("Thread interrupted while waiting for dynamoDB table to turn active", (Throwable)e);
        }
        LOG.info("Created dynamoDB table " + tableName);
    }

    private String generateLogSuffixString() {
        return StringUtils.join((String[])new String[]{"DynamoDb table = ", this.tableName, ", partition key = ", this.dynamoDBPartitionKey});
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join((String[])new String[]{state.name(), " lock at ", suffix});
    }
}

