/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import com.beust.jcommander.JCommander;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.aws.sync.AWSGlueCatalogSyncClient;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.sync.common.HoodieSyncConfig;

public class AwsGlueCatalogSyncTool
extends HiveSyncTool {
    public AwsGlueCatalogSyncTool(Properties props, Configuration hadoopConf) {
        super(props, hadoopConf);
    }

    protected void initSyncClient(HiveSyncConfig hiveSyncConfig) {
        this.syncClient = new AWSGlueCatalogSyncClient(hiveSyncConfig);
    }

    public static void main(String[] args) {
        HiveSyncConfig.HiveSyncConfigParams params = new HiveSyncConfig.HiveSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        TypedProperties props = params.toProps();
        Configuration hadoopConf = FSUtils.getFs((String)props.getString(HoodieSyncConfig.META_SYNC_BASE_PATH.key()), (Configuration)new Configuration()).getConf();
        try (AwsGlueCatalogSyncTool tool = new AwsGlueCatalogSyncTool((Properties)props, hadoopConf);){
            tool.syncHoodieTable();
        }
    }
}

