/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.credentials;

import java.util.Properties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieAWSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class HoodieConfigAWSAssumedRoleCredentialsProvider
implements AwsCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieConfigAWSAssumedRoleCredentialsProvider.class);
    private final StsAssumeRoleCredentialsProvider credentialsProvider;

    public HoodieConfigAWSAssumedRoleCredentialsProvider(Properties props) {
        String roleArn = props.getProperty(HoodieAWSConfig.AWS_ASSUME_ROLE_ARN.key());
        String externalId = props.getProperty(HoodieAWSConfig.AWS_ASSUME_ROLE_EXTERNAL_ID.key());
        String sessionName = props.getProperty(HoodieAWSConfig.AWS_ASSUME_ROLE_SESSION_NAME.key());
        AssumeRoleRequest req = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(sessionName).externalId(externalId).build();
        StsClient stsClient = (StsClient)StsClient.builder().build();
        this.credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(req).build();
    }

    public static boolean validConf(Properties props) {
        String roleArn = props.getProperty(HoodieAWSConfig.AWS_ASSUME_ROLE_ARN.key());
        return !StringUtils.isNullOrEmpty((String)roleArn);
    }

    public AwsCredentials resolveCredentials() {
        return this.credentialsProvider.resolveCredentials();
    }
}

