/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.credentials;

import java.util.Properties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieAWSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class HoodieConfigAWSCredentialsProvider
implements AwsCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieConfigAWSCredentialsProvider.class);
    private AwsCredentials awsCredentials;

    public HoodieConfigAWSCredentialsProvider(Properties props) {
        String accessKey = props.getProperty(HoodieAWSConfig.AWS_ACCESS_KEY.key());
        String secretKey = props.getProperty(HoodieAWSConfig.AWS_SECRET_KEY.key());
        String sessionToken = props.getProperty(HoodieAWSConfig.AWS_SESSION_TOKEN.key());
        if (StringUtils.isNullOrEmpty((String)accessKey) || StringUtils.isNullOrEmpty((String)secretKey)) {
            LOG.debug("AWS access key or secret key not found in the Hudi configuration. Use default AWS credentials");
        } else {
            this.awsCredentials = HoodieConfigAWSCredentialsProvider.createCredentials(accessKey, secretKey, sessionToken);
        }
    }

    private static AwsCredentials createCredentials(String accessKey, String secretKey, String sessionToken) {
        return sessionToken == null ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
    }

    public AwsCredentials resolveCredentials() {
        return this.awsCredentials;
    }
}

