/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.aws.sync.HoodieGlueSyncException;
import org.apache.hudi.aws.sync.util.GluePartitionFilterGenerator;
import org.apache.hudi.aws.utils.S3Utils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CustomizedThreadFactory;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.MapUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.GlueCatalogSyncClientConfig;
import org.apache.hudi.config.HoodieAWSConfig;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.GlueAsyncClientBuilder;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequestEntry;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreatePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.DeletePartitionIndexRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionIndexesResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.PartitionIndex;
import software.amazon.awssdk.services.glue.model.PartitionIndexDescriptor;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.services.glue.model.Segment;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;

public class AWSGlueCatalogSyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(AWSGlueCatalogSyncClient.class);
    private static final int MAX_PARTITIONS_PER_CHANGE_REQUEST = 100;
    private static final int MAX_PARTITIONS_PER_READ_REQUEST = 1000;
    private static final int MAX_DELETE_PARTITIONS_PER_REQUEST = 25;
    protected final GlueAsyncClient awsGlue;
    private static final String GLUE_PARTITION_INDEX_ENABLE = "partition_filtering.enabled";
    private static final int PARTITION_INDEX_MAX_NUMBER = 3;
    private static final String ENABLE_MDT_LISTING = "hudi.metadata-listing-enabled";
    private final String databaseName;
    private final Boolean skipTableArchive;
    private final String enableMetadataTable;
    private final int allPartitionsReadParallelism;
    private final int changedPartitionsReadParallelism;
    private final int changeParallelism;

    public AWSGlueCatalogSyncClient(HiveSyncConfig config, HoodieTableMetaClient metaClient) {
        this(AWSGlueCatalogSyncClient.buildAsyncClient(config), config, metaClient);
    }

    AWSGlueCatalogSyncClient(GlueAsyncClient awsGlue, HiveSyncConfig config, HoodieTableMetaClient metaClient) {
        super((HoodieSyncConfig)config, metaClient);
        this.awsGlue = awsGlue;
        this.databaseName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        this.skipTableArchive = config.getBooleanOrDefault(GlueCatalogSyncClientConfig.GLUE_SKIP_TABLE_ARCHIVE);
        this.enableMetadataTable = Boolean.toString(config.getBoolean(GlueCatalogSyncClientConfig.GLUE_METADATA_FILE_LISTING)).toUpperCase();
        this.allPartitionsReadParallelism = config.getIntOrDefault(GlueCatalogSyncClientConfig.ALL_PARTITIONS_READ_PARALLELISM);
        this.changedPartitionsReadParallelism = config.getIntOrDefault(GlueCatalogSyncClientConfig.CHANGED_PARTITIONS_READ_PARALLELISM);
        this.changeParallelism = config.getIntOrDefault(GlueCatalogSyncClientConfig.PARTITION_CHANGE_PARALLELISM);
    }

    private static GlueAsyncClient buildAsyncClient(HiveSyncConfig config) {
        try {
            GlueAsyncClientBuilder awsGlueBuilder = (GlueAsyncClientBuilder)GlueAsyncClient.builder().credentialsProvider(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider((Properties)config.getProps()));
            awsGlueBuilder = config.getString(HoodieAWSConfig.AWS_GLUE_ENDPOINT) == null ? awsGlueBuilder : (GlueAsyncClientBuilder)awsGlueBuilder.endpointOverride(new URI(config.getString(HoodieAWSConfig.AWS_GLUE_ENDPOINT)));
            awsGlueBuilder = config.getString(HoodieAWSConfig.AWS_GLUE_REGION) == null ? awsGlueBuilder : (GlueAsyncClientBuilder)awsGlueBuilder.region(Region.of((String)config.getString(HoodieAWSConfig.AWS_GLUE_REGION)));
            return (GlueAsyncClient)awsGlueBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Partition> getPartitionsSegment(Segment segment, String tableName) {
        try {
            GetPartitionsResponse result;
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            String nextToken = null;
            do {
                result = (GetPartitionsResponse)this.awsGlue.getPartitions((GetPartitionsRequest)GetPartitionsRequest.builder().databaseName(this.databaseName).tableName(tableName).excludeColumnSchema(Boolean.valueOf(true)).segment(segment).nextToken(nextToken).build()).get();
                partitions.addAll(result.partitions().stream().map(p -> new Partition(p.values(), p.storageDescriptor().location())).collect(Collectors.toList()));
            } while ((nextToken = result.nextToken()) != null);
            return partitions;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get all partitions for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public List<Partition> getAllPartitions(String tableName) {
        ExecutorService executorService = Executors.newFixedThreadPool(this.allPartitionsReadParallelism, (ThreadFactory)new CustomizedThreadFactory("glue-sync-all-partitions", true));
        try {
            ArrayList<Object> segments = new ArrayList<Object>();
            for (int i = 0; i < this.allPartitionsReadParallelism; ++i) {
                segments.add(Segment.builder().segmentNumber(Integer.valueOf(i)).totalSegments(Integer.valueOf(this.allPartitionsReadParallelism)).build());
            }
            List futures = segments.stream().map(segment -> executorService.submit(() -> this.getPartitionsSegment((Segment)segment, tableName))).collect(Collectors.toList());
            ArrayList partitions = new ArrayList();
            for (Future future : futures) {
                partitions.addAll((Collection)future.get());
            }
            ArrayList arrayList = partitions;
            return arrayList;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get all partitions for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public List<Partition> getPartitionsFromList(String tableName, List<String> partitionList) {
        ArrayList arrayList;
        if (partitionList.isEmpty()) {
            LOG.info("No partitions to read for " + TableUtils.tableId((String)this.databaseName, (String)tableName));
            return Collections.emptyList();
        }
        HoodieTimer timer = HoodieTimer.start();
        List batches = CollectionUtils.batches(partitionList, (int)1000);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(this.changedPartitionsReadParallelism, batches.size()), (ThreadFactory)new CustomizedThreadFactory("glue-sync-get-partitions-" + tableName, true));
        try {
            List futures = batches.stream().map(batch -> executorService.submit(() -> this.getChangedPartitions((List<String>)batch, tableName))).collect(Collectors.toList());
            ArrayList partitions = new ArrayList();
            for (Future future : futures) {
                partitions.addAll((Collection)future.get());
            }
            LOG.info("Requested {} partitions, found existing {} partitions, new {} partitions", new Object[]{partitionList.size(), partitions.size(), partitionList.size() - partitions.size()});
            arrayList = partitions;
            executorService.shutdownNow();
        }
        catch (Exception e) {
            try {
                throw new HoodieGlueSyncException("Failed to get all partitions for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
            }
            catch (Throwable throwable) {
                executorService.shutdownNow();
                LOG.info("Took {} ms to get {} partitions for table {}", new Object[]{timer.endTimer(), partitionList.size(), TableUtils.tableId((String)this.databaseName, (String)tableName)});
                throw throwable;
            }
        }
        LOG.info("Took {} ms to get {} partitions for table {}", new Object[]{timer.endTimer(), partitionList.size(), TableUtils.tableId((String)this.databaseName, (String)tableName)});
        return arrayList;
    }

    private List<Partition> getChangedPartitions(List<String> changedPartitions, String tableName) throws ExecutionException, InterruptedException {
        List partitionValueList = changedPartitions.stream().map(str -> (PartitionValueList)PartitionValueList.builder().values((Collection)this.partitionValueExtractor.extractPartitionValuesInPath(str)).build()).collect(Collectors.toList());
        BatchGetPartitionRequest request = (BatchGetPartitionRequest)BatchGetPartitionRequest.builder().databaseName(this.databaseName).tableName(tableName).partitionsToGet(partitionValueList).build();
        BatchGetPartitionResponse callResult = (BatchGetPartitionResponse)this.awsGlue.batchGetPartition(request).get();
        List<Partition> result = callResult.partitions().stream().map(p -> new Partition(p.values(), p.storageDescriptor().location())).collect(Collectors.toList());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        HoodieTimer timer;
        block3: {
            timer = HoodieTimer.start();
            try {
                if (!partitionsToAdd.isEmpty()) break block3;
                LOG.info("No partitions to add for " + TableUtils.tableId((String)this.databaseName, (String)tableName));
            }
            catch (Throwable throwable) {
                LOG.info("Added {} partitions to table {} in {} ms", new Object[]{partitionsToAdd.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
                throw throwable;
            }
            LOG.info("Added {} partitions to table {} in {} ms", new Object[]{partitionsToAdd.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
            return;
        }
        Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
        this.parallelizeChange(partitionsToAdd, this.changeParallelism, partitions -> this.addPartitionsToTableInternal(table, (List<String>)partitions), 100);
        LOG.info("Added {} partitions to table {} in {} ms", new Object[]{partitionsToAdd.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
    }

    private <T> void parallelizeChange(List<T> items, int parallelism, Consumer<List<T>> consumer, int sliceSize) {
        List batches = CollectionUtils.batches(items, (int)sliceSize);
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(parallelism, batches.size()), (ThreadFactory)new CustomizedThreadFactory("glue-sync", true));
        try {
            List futures = batches.stream().map(item -> executorService.submit(() -> consumer.accept((List)item))).collect(Collectors.toList());
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to parallelize operation", e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void addPartitionsToTableInternal(Table table, List<String> partitionsToAdd) {
        block3: {
            try {
                StorageDescriptor sd = table.storageDescriptor();
                List partitionInputList = partitionsToAdd.stream().map(partition -> {
                    String fullPartitionPath = FSUtils.constructAbsolutePath((String)S3Utils.s3aToS3(this.getBasePath()), (String)partition).toString();
                    List partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(partition);
                    StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.location(fullPartitionPath));
                    return (PartitionInput)PartitionInput.builder().values((Collection)partitionValues).storageDescriptor(partitionSD).build();
                }).collect(Collectors.toList());
                BatchCreatePartitionRequest request = (BatchCreatePartitionRequest)BatchCreatePartitionRequest.builder().databaseName(this.databaseName).tableName(table.name()).partitionInputList(partitionInputList).build();
                CompletableFuture future = this.awsGlue.batchCreatePartition(request);
                BatchCreatePartitionResponse response = (BatchCreatePartitionResponse)future.get();
                if (!CollectionUtils.nonEmpty((Collection)response.errors())) break block3;
                if (response.errors().stream().allMatch(error -> "AlreadyExistsException".equals(error.errorDetail().errorCode()))) {
                    LOG.warn("Partitions already exist in glue: " + response.errors());
                    break block3;
                }
                throw new HoodieGlueSyncException("Fail to add partitions to " + TableUtils.tableId((String)this.databaseName, (String)table.name()) + " with error(s): " + response.errors());
            }
            catch (Exception e) {
                throw new HoodieGlueSyncException("Fail to add partitions to " + TableUtils.tableId((String)this.databaseName, (String)table.name()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        HoodieTimer timer;
        block3: {
            timer = HoodieTimer.start();
            try {
                if (!changedPartitions.isEmpty()) break block3;
                LOG.info("No partitions to update for " + TableUtils.tableId((String)this.databaseName, (String)tableName));
            }
            catch (Throwable throwable) {
                LOG.info("Updated {} partitions to table {} in {} ms", new Object[]{changedPartitions.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
                throw throwable;
            }
            LOG.info("Updated {} partitions to table {} in {} ms", new Object[]{changedPartitions.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
            return;
        }
        Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
        this.parallelizeChange(changedPartitions, this.changeParallelism, partitions -> this.updatePartitionsToTableInternal(table, (List<String>)partitions), 100);
        LOG.info("Updated {} partitions to table {} in {} ms", new Object[]{changedPartitions.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
    }

    private void updatePartitionsToTableInternal(Table table, List<String> changedPartitions) {
        try {
            StorageDescriptor sd = table.storageDescriptor();
            List updatePartitionEntries = changedPartitions.stream().map(partition -> {
                String fullPartitionPath = FSUtils.constructAbsolutePath((String)S3Utils.s3aToS3(this.getBasePath()), (String)partition).toString();
                List partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(partition);
                StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.location(fullPartitionPath));
                PartitionInput partitionInput = (PartitionInput)PartitionInput.builder().values((Collection)partitionValues).storageDescriptor(partitionSD).build();
                return (BatchUpdatePartitionRequestEntry)BatchUpdatePartitionRequestEntry.builder().partitionInput(partitionInput).partitionValueList((Collection)partitionValues).build();
            }).collect(Collectors.toList());
            BatchUpdatePartitionRequest request = (BatchUpdatePartitionRequest)BatchUpdatePartitionRequest.builder().databaseName(this.databaseName).tableName(table.name()).entries(updatePartitionEntries).build();
            CompletableFuture future = this.awsGlue.batchUpdatePartition(request);
            BatchUpdatePartitionResponse response = (BatchUpdatePartitionResponse)future.get();
            if (CollectionUtils.nonEmpty((Collection)response.errors())) {
                throw new HoodieGlueSyncException("Fail to update partitions to " + TableUtils.tableId((String)this.databaseName, (String)table.name()) + " with error(s): " + response.errors());
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update partitions to " + TableUtils.tableId((String)this.databaseName, (String)table.name()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        HoodieTimer timer;
        block3: {
            timer = HoodieTimer.start();
            try {
                if (!partitionsToDrop.isEmpty()) break block3;
                LOG.info("No partitions to drop for " + TableUtils.tableId((String)this.databaseName, (String)tableName));
            }
            catch (Throwable throwable) {
                LOG.info("Deleted {} partitions to table {} in {} ms", new Object[]{partitionsToDrop.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
                throw throwable;
            }
            LOG.info("Deleted {} partitions to table {} in {} ms", new Object[]{partitionsToDrop.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
            return;
        }
        this.parallelizeChange(partitionsToDrop, this.changeParallelism, partitions -> this.dropPartitionsInternal(tableName, (List<String>)partitions), 25);
        LOG.info("Deleted {} partitions to table {} in {} ms", new Object[]{partitionsToDrop.size(), TableUtils.tableId((String)this.databaseName, (String)tableName), timer.endTimer()});
    }

    private void dropPartitionsInternal(String tableName, List<String> partitionsToDrop) {
        try {
            List partitionValueLists = partitionsToDrop.stream().map(partition -> (PartitionValueList)PartitionValueList.builder().values((Collection)this.partitionValueExtractor.extractPartitionValuesInPath(partition)).build()).collect(Collectors.toList());
            BatchDeletePartitionRequest batchDeletePartitionRequest = (BatchDeletePartitionRequest)BatchDeletePartitionRequest.builder().databaseName(this.databaseName).tableName(tableName).partitionsToDelete(partitionValueLists).build();
            CompletableFuture future = this.awsGlue.batchDeletePartition(batchDeletePartitionRequest);
            BatchDeletePartitionResponse response = (BatchDeletePartitionResponse)future.get();
            if (CollectionUtils.nonEmpty((Collection)response.errors())) {
                throw new HoodieGlueSyncException("Fail to drop partitions to " + TableUtils.tableId((String)this.databaseName, (String)tableName) + " with error(s): " + response.errors());
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to drop partitions to " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public boolean updateTableProperties(String tableName, Map<String, String> tableProperties) {
        try {
            tableProperties.put(ENABLE_MDT_LISTING, this.enableMetadataTable);
            return AWSGlueCatalogSyncClient.updateTableParameters(this.awsGlue, this.databaseName, tableName, tableProperties, this.skipTableArchive);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update properties for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    private void setComments(List<Column> columns, Map<String, Option<String>> commentsMap) {
        columns.forEach(column -> {
            String comment = (String)commentsMap.getOrDefault(column.name(), Option.empty()).orElse(null);
            Column.builder().comment(comment).build();
        });
    }

    private String getTableDoc() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(true).getDoc();
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get schema's doc from storage : ", e);
        }
    }

    public List<FieldSchema> getStorageFieldSchemas() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(true).getFields().stream().map(f -> new FieldSchema(f.name(), f.schema().getType().getName(), f.doc())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get field schemas from storage : ", e);
        }
    }

    public boolean updateTableComments(String tableName, List<FieldSchema> fromMetastore, List<FieldSchema> fromStorage) {
        Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
        Map<String, Option<String>> commentsMap = fromStorage.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getComment));
        StorageDescriptor storageDescriptor = table.storageDescriptor();
        List columns = storageDescriptor.columns();
        this.setComments(columns, commentsMap);
        List partitionKeys = table.partitionKeys();
        this.setComments(partitionKeys, commentsMap);
        String tableDescription = this.getTableDoc();
        if (AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName).storageDescriptor().equals((Object)storageDescriptor) && AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName).partitionKeys().equals(partitionKeys)) {
            return false;
        }
        Instant now = Instant.now();
        TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).description(tableDescription).tableType(table.tableType()).parameters(table.parameters()).partitionKeys((Collection)partitionKeys).storageDescriptor(storageDescriptor).lastAccessTime(now).lastAnalyzedTime(now).build();
        UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(this.databaseName).tableInput(updatedTableInput).build();
        try {
            this.awsGlue.updateTable(request).get();
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update table comments " + TableUtils.tableId((String)this.databaseName, (String)table.name()), e);
        }
        return true;
    }

    public void updateTableSchema(String tableName, MessageType newSchema, SchemaDifference schemaDiff) {
        try {
            boolean cascade;
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            LinkedHashMap newSchemaMap = HiveSchemaUtil.parquetSchemaToMapSchema((MessageType)newSchema, (boolean)this.config.getBoolean(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE), (boolean)false);
            List<Column> newColumns = this.getColumnsFromSchema(newSchemaMap);
            StorageDescriptor sd = table.storageDescriptor();
            StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.columns((Collection)newColumns));
            Instant now = Instant.now();
            TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).tableType(table.tableType()).parameters(table.parameters()).partitionKeys((Collection)table.partitionKeys()).storageDescriptor(partitionSD).lastAccessTime(now).lastAnalyzedTime(now).build();
            UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(this.databaseName).skipArchive(this.skipTableArchive).tableInput(updatedTableInput).build();
            this.awsGlue.updateTable(request).get();
            boolean bl = cascade = this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).size() > 0 && !schemaDiff.getUpdateColumnTypes().isEmpty();
            if (cascade) {
                LOG.info("Cascading column changes to partitions");
                List<String> allPartitions = this.getAllPartitions(tableName).stream().map(partition -> this.getStringFromPartition(table.partitionKeys(), partition.getValues())).collect(Collectors.toList());
                this.updatePartitionsToTable(tableName, allPartitions);
            }
            this.awsGlue.updateTable(request).get();
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update definition for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    private String getStringFromPartition(List<Column> partitionKeys, List<String> values) {
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (int i = 0; i < partitionKeys.size(); ++i) {
            partitionValues.add(String.format("%s=%s", partitionKeys.get(i).name(), values.get(i)));
        }
        return partitionValues.stream().collect(Collectors.joining("/"));
    }

    public void createOrReplaceTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        if (!this.tableExists(tableName)) {
            this.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
            return;
        }
        try {
            this.validateSchemaAndProperties(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
            this.dropTable(tableName);
            this.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to recreate the table" + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    private void validateSchemaAndProperties(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        String tempTableName = this.generateTempTableName(tableName);
        this.createTable(tempTableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
        this.dropTable(tempTableName);
    }

    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        if (this.tableExists(tableName)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (!this.config.getBoolean(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE).booleanValue()) {
            params.put("EXTERNAL", "TRUE");
        }
        params.put(ENABLE_MDT_LISTING, this.enableMetadataTable);
        params.putAll(tableProperties);
        try {
            LinkedHashMap mapSchema = HiveSchemaUtil.parquetSchemaToMapSchema((MessageType)storageSchema, (boolean)this.config.getBoolean(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE), (boolean)false);
            List<Column> schemaWithoutPartitionKeys = this.getColumnsFromSchema(mapSchema);
            List schemaPartitionKeys = this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).stream().map(partitionKey -> {
                String keyType = HiveSchemaUtil.getPartitionKeyType((Map)mapSchema, (String)partitionKey);
                return (Column)Column.builder().name(partitionKey).type(keyType.toLowerCase()).comment("").build();
            }).collect(Collectors.toList());
            serdeProperties.put("serialization.format", "1");
            StorageDescriptor storageDescriptor = (StorageDescriptor)StorageDescriptor.builder().serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary(serdeClass).parameters(serdeProperties).build()).location(S3Utils.s3aToS3(this.getBasePath())).inputFormat(inputFormatClass).outputFormat(outputFormatClass).columns(schemaWithoutPartitionKeys).build();
            Instant now = Instant.now();
            TableInput tableInput = (TableInput)TableInput.builder().name(tableName).tableType(TableType.EXTERNAL_TABLE.toString()).parameters(params).partitionKeys(schemaPartitionKeys).storageDescriptor(storageDescriptor).lastAccessTime(now).lastAnalyzedTime(now).build();
            CreateTableRequest request = (CreateTableRequest)CreateTableRequest.builder().databaseName(this.databaseName).tableInput(tableInput).build();
            CreateTableResponse response = (CreateTableResponse)this.awsGlue.createTable(request).get();
            LOG.info("Created table " + TableUtils.tableId((String)this.databaseName, (String)tableName) + " : " + response);
        }
        catch (AlreadyExistsException e) {
            LOG.warn("Table " + TableUtils.tableId((String)this.databaseName, (String)tableName) + " already exists.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to create " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public void managePartitionIndexes(String tableName) throws ExecutionException, InterruptedException {
        if (!this.config.getBooleanOrDefault(GlueCatalogSyncClientConfig.META_SYNC_PARTITION_INDEX_FIELDS_ENABLE)) {
            if (this.getPartitionIndexEnable(tableName).booleanValue()) {
                LOG.warn("Deactivating partition indexing");
                this.updatePartitionIndexEnable(tableName, false);
            }
            GetPartitionIndexesRequest indexesRequest = (GetPartitionIndexesRequest)GetPartitionIndexesRequest.builder().databaseName(this.databaseName).tableName(tableName).build();
            GetPartitionIndexesResponse existingIdxsResp = (GetPartitionIndexesResponse)this.awsGlue.getPartitionIndexes(indexesRequest).get();
            for (PartitionIndexDescriptor idsToDelete : existingIdxsResp.partitionIndexDescriptorList()) {
                LOG.warn("Dropping partition index: " + idsToDelete.indexName());
                DeletePartitionIndexRequest idxToDelete = (DeletePartitionIndexRequest)DeletePartitionIndexRequest.builder().databaseName(this.databaseName).tableName(tableName).indexName(idsToDelete.indexName()).build();
                this.awsGlue.deletePartitionIndex(idxToDelete).get();
            }
        } else {
            if (!this.getPartitionIndexEnable(tableName).booleanValue()) {
                LOG.warn("Activating partition indexing");
                this.updatePartitionIndexEnable(tableName, true);
            }
            List<List<String>> partitionsIndexNeeded = this.parsePartitionsIndexConfig();
            GetPartitionIndexesRequest indexesRequest = (GetPartitionIndexesRequest)GetPartitionIndexesRequest.builder().databaseName(this.databaseName).tableName(tableName).build();
            GetPartitionIndexesResponse existingIdxsResp = (GetPartitionIndexesResponse)this.awsGlue.getPartitionIndexes(indexesRequest).get();
            boolean indexesChanges = false;
            for (PartitionIndexDescriptor partitionIndexDescriptor : existingIdxsResp.partitionIndexDescriptorList()) {
                List idxColumns = partitionIndexDescriptor.keys().stream().map(key -> key.name()).collect(Collectors.toList());
                Object toBeRemoved = true;
                for (List<String> neededIdx : partitionsIndexNeeded) {
                    if (!neededIdx.equals(idxColumns)) continue;
                    toBeRemoved = false;
                }
                if (!((Boolean)toBeRemoved).booleanValue()) continue;
                indexesChanges = true;
                DeletePartitionIndexRequest idxToDelete = (DeletePartitionIndexRequest)DeletePartitionIndexRequest.builder().databaseName(this.databaseName).tableName(tableName).indexName(partitionIndexDescriptor.indexName()).build();
                LOG.warn("Dropping irrelevant index: " + partitionIndexDescriptor.indexName());
                this.awsGlue.deletePartitionIndex(idxToDelete).get();
            }
            if (indexesChanges) {
                existingIdxsResp = (GetPartitionIndexesResponse)this.awsGlue.getPartitionIndexes(indexesRequest).get();
            }
            for (List list : partitionsIndexNeeded) {
                Boolean toBeCreated = true;
                for (PartitionIndexDescriptor existingIdx : existingIdxsResp.partitionIndexDescriptorList()) {
                    List collect = existingIdx.keys().stream().map(key -> key.name()).collect(Collectors.toList());
                    if (!collect.equals(list)) continue;
                    toBeCreated = false;
                }
                if (!toBeCreated.booleanValue()) continue;
                String newIdxName = String.format("hudi_managed_%s", list.toString());
                PartitionIndex newIdx = (PartitionIndex)PartitionIndex.builder().indexName(newIdxName).keys((Collection)list).build();
                LOG.warn("Creating new partition index: " + newIdxName);
                CreatePartitionIndexRequest creationRequest = (CreatePartitionIndexRequest)CreatePartitionIndexRequest.builder().databaseName(this.databaseName).tableName(tableName).partitionIndex(newIdx).build();
                this.awsGlue.createPartitionIndex(creationRequest).get();
            }
        }
    }

    protected List<List<String>> parsePartitionsIndexConfig() {
        this.config.setDefaultValue(GlueCatalogSyncClientConfig.META_SYNC_PARTITION_INDEX_FIELDS);
        String rawPartitionIndex = this.config.getString(GlueCatalogSyncClientConfig.META_SYNC_PARTITION_INDEX_FIELDS);
        List<List<String>> indexes = Arrays.stream(rawPartitionIndex.split(",")).map(idx -> Arrays.stream(idx.split(";")).collect(Collectors.toList())).collect(Collectors.toList());
        if (indexes.size() > 3) {
            LOG.warn(String.format("Only considering first %s indexes", 3));
            return indexes.subList(0, 3);
        }
        return indexes;
    }

    public Boolean getPartitionIndexEnable(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            return Boolean.valueOf((String)table.parameters().get(GLUE_PARTITION_INDEX_ENABLE));
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get parameter partition_filtering.enabled time for " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public void updatePartitionIndexEnable(String tableName, Boolean enable) {
        try {
            AWSGlueCatalogSyncClient.updateTableParameters(this.awsGlue, this.databaseName, tableName, Collections.singletonMap(GLUE_PARTITION_INDEX_ENABLE, enable.toString()), false);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update parameter partition_filtering.enabled time for " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public Map<String, String> getMetastoreSchema(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            Map<String, String> partitionKeysMap = table.partitionKeys().stream().collect(Collectors.toMap(Column::name, f -> f.type().toUpperCase()));
            Map<String, String> columnsMap = table.storageDescriptor().columns().stream().collect(Collectors.toMap(Column::name, f -> f.type().toUpperCase()));
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.putAll(columnsMap);
            schema.putAll(partitionKeysMap);
            return schema;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get schema for table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public boolean tableExists(String tableName) {
        GetTableRequest request = (GetTableRequest)GetTableRequest.builder().databaseName(this.databaseName).name(tableName).build();
        try {
            return Objects.nonNull(((GetTableResponse)this.awsGlue.getTable(request).get()).table());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                LOG.warn("Table not found: " + TableUtils.tableId((String)this.databaseName, (String)tableName), (Throwable)e);
                return false;
            }
            throw new HoodieGlueSyncException("Fail to get table: " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get table: " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public boolean databaseExists(String databaseName) {
        GetDatabaseRequest request = (GetDatabaseRequest)GetDatabaseRequest.builder().name(databaseName).build();
        try {
            return Objects.nonNull(((GetDatabaseResponse)this.awsGlue.getDatabase(request).get()).database());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                LOG.warn("Database not found: " + databaseName, (Throwable)e);
                return false;
            }
            throw new HoodieGlueSyncException("Fail to check if database exists " + databaseName, e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to check if database exists " + databaseName, e);
        }
    }

    public void createDatabase(String databaseName) {
        if (this.databaseExists(databaseName)) {
            return;
        }
        CreateDatabaseRequest request = (CreateDatabaseRequest)CreateDatabaseRequest.builder().databaseInput((DatabaseInput)DatabaseInput.builder().name(databaseName).description("Automatically created by " + ((Object)((Object)this)).getClass().getName()).parameters(null).locationUri(null).build()).build();
        try {
            CreateDatabaseResponse result = (CreateDatabaseResponse)this.awsGlue.createDatabase(request).get();
            LOG.info("Successfully created database in AWS Glue: " + result.toString());
        }
        catch (AlreadyExistsException e) {
            LOG.warn("AWS Glue Database " + databaseName + " already exists", (Throwable)e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to create database " + databaseName, e);
        }
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            return Option.ofNullable(table.parameters().getOrDefault("last_commit_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get last sync commit time for " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public Option<String> getLastCommitCompletionTimeSynced(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            return Option.ofNullable(table.parameters().getOrDefault("last_commit_completion_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get the last commit completion time synced from the table " + tableName, e);
        }
    }

    public void close() {
        this.awsGlue.close();
    }

    public void updateLastCommitTimeSynced(String tableName) {
        HoodieTimeline activeTimeline = this.getActiveTimeline();
        Option lastCommitSynced = activeTimeline.lastInstant().map(HoodieInstant::requestedTime);
        Option lastCommitCompletionSynced = activeTimeline.getInstantsOrderedByCompletionTime().skip(activeTimeline.countInstants() - 1).findFirst().map(i -> Option.of((Object)i.getCompletionTime())).orElse(Option.empty());
        if (lastCommitSynced.isPresent()) {
            try {
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                propertyMap.put("last_commit_time_sync", (String)lastCommitSynced.get());
                if (lastCommitCompletionSynced.isPresent()) {
                    propertyMap.put("last_commit_completion_time_sync", (String)lastCommitCompletionSynced.get());
                }
                AWSGlueCatalogSyncClient.updateTableParameters(this.awsGlue, this.databaseName, tableName, propertyMap, this.skipTableArchive);
            }
            catch (Exception e) {
                throw new HoodieGlueSyncException("Fail to update last sync commit time for " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
            }
        } else {
            LOG.warn("No commit in active timeline.");
        }
        try {
            this.managePartitionIndexes(tableName);
        }
        catch (ExecutionException e) {
            LOG.warn("An indexation process is currently running.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Something went wrong with partition index", (Throwable)e);
        }
    }

    public void dropTable(String tableName) {
        DeleteTableRequest deleteTableRequest = (DeleteTableRequest)DeleteTableRequest.builder().databaseName(this.databaseName).name(tableName).build();
        try {
            this.awsGlue.deleteTable(deleteTableRequest).get();
            LOG.info("Successfully deleted table in AWS Glue: {}.{}", (Object)this.databaseName, (Object)tableName);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new HoodieGlueSyncException("Failed to delete table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    public List<FieldSchema> getMetastoreFieldSchemas(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            List<FieldSchema> partitionFields = this.getFieldSchemas(table.partitionKeys());
            List<FieldSchema> columnsFields = this.getFieldSchemas(table.storageDescriptor().columns());
            columnsFields.addAll(partitionFields);
            return columnsFields;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get field schemas from metastore for table : " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    private List<FieldSchema> getFieldSchemas(List<Column> columns) {
        return columns.stream().map(column -> new FieldSchema(column.name(), column.type(), column.comment())).collect(Collectors.toList());
    }

    public Option<String> getLastReplicatedTime(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getLastReplicatedTime`");
    }

    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        throw new UnsupportedOperationException("Not supported: `updateLastReplicatedTimeStamp`");
    }

    public void deleteLastReplicatedTimeStamp(String tableName) {
        throw new UnsupportedOperationException("Not supported: `deleteLastReplicatedTimeStamp`");
    }

    public String generatePushDownFilter(List<String> writtenPartitions, List<FieldSchema> partitionFields) {
        return new GluePartitionFilterGenerator().generatePushDownFilter(writtenPartitions, partitionFields, (HiveSyncConfig)this.config);
    }

    public boolean updateSerdeProperties(String tableName, Map<String, String> serdeProperties, boolean useRealtimeFormat) {
        if (MapUtils.isNullOrEmpty(serdeProperties)) {
            return false;
        }
        try {
            serdeProperties.putIfAbsent("serialization.format", "1");
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            StorageDescriptor existingTableStorageDescriptor = table.storageDescriptor();
            if (existingTableStorageDescriptor != null && existingTableStorageDescriptor.serdeInfo() != null && existingTableStorageDescriptor.serdeInfo().parameters().size() == serdeProperties.size()) {
                Map existingSerdeProperties = existingTableStorageDescriptor.serdeInfo().parameters();
                boolean different = serdeProperties.entrySet().stream().anyMatch(e -> !existingSerdeProperties.containsKey(e.getKey()) || !((String)existingSerdeProperties.get(e.getKey())).equals(e.getValue()));
                if (!different) {
                    LOG.debug("Table " + tableName + " serdeProperties already up to date, skip update serde properties.");
                    return false;
                }
            }
            HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf((String)this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
            String serDeClassName = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)baseFileFormat);
            SerDeInfo newSerdeInfo = (SerDeInfo)SerDeInfo.builder().serializationLibrary(serDeClassName).parameters(serdeProperties).build();
            StorageDescriptor storageDescriptor = (StorageDescriptor)table.storageDescriptor().toBuilder().serdeInfo(newSerdeInfo).build();
            TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).tableType(table.tableType()).parameters(table.parameters()).partitionKeys((Collection)table.partitionKeys()).storageDescriptor(storageDescriptor).lastAccessTime(table.lastAccessTime()).lastAccessTime(table.lastAnalyzedTime()).build();
            UpdateTableRequest updateTableRequest = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(this.databaseName).tableInput(updatedTableInput).build();
            this.awsGlue.updateTable(updateTableRequest).get();
            return true;
        }
        catch (Exception e2) {
            throw new HoodieGlueSyncException("Failed to update table serde info for table: " + tableName, e2);
        }
    }

    public String getTableLocation(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            return table.storageDescriptor().location();
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get base path for the table " + TableUtils.tableId((String)this.databaseName, (String)tableName), e);
        }
    }

    private List<Column> getColumnsFromSchema(Map<String, String> mapSchema) {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (String key : mapSchema.keySet()) {
            if (this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).contains(key)) continue;
            String keyType = HiveSchemaUtil.getPartitionKeyType(mapSchema, (String)key);
            Column column = (Column)Column.builder().name(key).type(keyType.toLowerCase()).comment("").build();
            cols.add(column);
        }
        return cols;
    }

    private static Table getTable(GlueAsyncClient awsGlue, String databaseName, String tableName) throws HoodieGlueSyncException {
        GetTableRequest request = (GetTableRequest)GetTableRequest.builder().databaseName(databaseName).name(tableName).build();
        try {
            return ((GetTableResponse)awsGlue.getTable(request).get()).table();
        }
        catch (EntityNotFoundException e) {
            throw new HoodieGlueSyncException("Table not found: " + TableUtils.tableId((String)databaseName, (String)tableName), e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get table " + TableUtils.tableId((String)databaseName, (String)tableName), e);
        }
    }

    private static boolean updateTableParameters(GlueAsyncClient awsGlue, String databaseName, String tableName, Map<String, String> updatingParams, boolean skipTableArchive) {
        if (MapUtils.isNullOrEmpty(updatingParams)) {
            return false;
        }
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(awsGlue, databaseName, tableName);
            Map remoteParams = table.parameters();
            if (MapUtils.containsAll((Map)remoteParams, updatingParams)) {
                return false;
            }
            HashMap<String, String> newParams = new HashMap<String, String>();
            newParams.putAll(table.parameters());
            newParams.putAll(updatingParams);
            Instant now = Instant.now();
            TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).tableType(table.tableType()).parameters(newParams).partitionKeys((Collection)table.partitionKeys()).storageDescriptor(table.storageDescriptor()).lastAccessTime(now).lastAnalyzedTime(now).build();
            UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(databaseName).tableInput(updatedTableInput).skipArchive(Boolean.valueOf(skipTableArchive)).build();
            awsGlue.updateTable(request).get();
            return true;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update params for table " + TableUtils.tableId((String)databaseName, (String)tableName) + ": " + updatingParams, e);
        }
    }

    private static enum TableType {
        MANAGED_TABLE,
        EXTERNAL_TABLE,
        VIRTUAL_VIEW,
        INDEX_TABLE,
        MATERIALIZED_VIEW;

    }
}

