/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.transaction.lock;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.aws.transaction.lock.DynamoDBBasedLockProviderBase;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.DynamoDbBasedLockConfig;
import org.apache.hudi.storage.StorageConfiguration;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@NotThreadSafe
public class DynamoDBBasedLockProvider
extends DynamoDBBasedLockProviderBase {
    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        this(lockConfiguration, conf, null);
    }

    public DynamoDBBasedLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf, DynamoDbClient dynamoDB) {
        super(lockConfiguration, conf, dynamoDB);
    }

    @Override
    public String getDynamoDBPartitionKey(LockConfiguration lockConfiguration) {
        DynamoDbBasedLockConfig config = new DynamoDbBasedLockConfig.Builder().fromProperties(lockConfiguration.getConfig()).build();
        ValidationUtils.checkArgument((boolean)config.contains(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY), (String)("Config key is not found: " + DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY.key()));
        return config.getString(DynamoDbBasedLockConfig.DYNAMODB_LOCK_PARTITION_KEY);
    }
}

