/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.cloudwatch;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.credentials.HoodieAWSCredentialsProviderFactory;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

public class CloudWatchReporter
extends ScheduledReporter {
    static final String DIMENSION_TABLE_NAME_KEY = "Table";
    static final String DIMENSION_METRIC_TYPE_KEY = "Metric Type";
    static final String DIMENSION_GAUGE_TYPE_VALUE = "gauge";
    static final String DIMENSION_COUNT_TYPE_VALUE = "count";
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchReporter.class);
    private final CloudWatchAsyncClient cloudWatchClientAsync;
    private final Clock clock;
    private final String prefix;
    private final String namespace;
    private final int maxDatumsPerRequest;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected CloudWatchReporter(MetricRegistry registry, CloudWatchAsyncClient cloudWatchClientAsync, Clock clock, String prefix, String namespace, int maxDatumsPerRequest, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, "hudi-cloudWatch-reporter", filter, rateUnit, durationUnit);
        this.cloudWatchClientAsync = cloudWatchClientAsync;
        this.clock = clock;
        this.prefix = prefix;
        this.namespace = namespace;
        this.maxDatumsPerRequest = maxDatumsPerRequest;
    }

    private static CloudWatchAsyncClient getAmazonCloudWatchClient(Properties props) {
        return (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().credentialsProvider(HoodieAWSCredentialsProviderFactory.getAwsCredentialsProvider(props))).build();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        LOG.info("Reporting Metrics to CloudWatch.");
        long timestampMilliSec = this.clock.getTime();
        ArrayList<MetricDatum> metricsData = new ArrayList<MetricDatum>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.processGauge(entry.getKey(), entry.getValue(), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)entry.getValue(), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)entry.getValue(), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)entry.getValue(), timestampMilliSec, metricsData);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.processCounter(entry.getKey(), (Counting)entry.getValue(), timestampMilliSec, metricsData);
        }
        this.report(metricsData);
    }

    private void report(List<MetricDatum> metricsData) {
        ArrayList<CompletableFuture> cloudWatchFutures = new ArrayList<CompletableFuture>(metricsData.size());
        ArrayList<List<MetricDatum>> partitions = new ArrayList<List<MetricDatum>>();
        for (int i = 0; i < metricsData.size(); i += this.maxDatumsPerRequest) {
            int n = Math.min(metricsData.size(), i + this.maxDatumsPerRequest);
            partitions.add(metricsData.subList(i, n));
        }
        for (List list : partitions) {
            PutMetricDataRequest request = (PutMetricDataRequest)PutMetricDataRequest.builder().namespace(this.namespace).metricData((Collection)list).build();
            cloudWatchFutures.add(this.cloudWatchClientAsync.putMetricData(request));
        }
        for (Future future : cloudWatchFutures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                LOG.error("Error reporting metrics to CloudWatch. The data in this CloudWatch request may have been discarded, and not made it to CloudWatch.", (Throwable)ex);
            }
        }
    }

    private void processGauge(String metricName, Gauge<?> gauge, long timestampMilliSec, List<MetricDatum> metricData) {
        Option.ofNullable((Object)gauge.getValue()).toJavaOptional().filter(value -> value instanceof Number).map(value -> (Number)value).ifPresent(value -> this.stageMetricDatum(metricName, value.doubleValue(), DIMENSION_GAUGE_TYPE_VALUE, StandardUnit.NONE, timestampMilliSec, metricData));
    }

    private void processCounter(String metricName, Counting counter, long timestampMilliSec, List<MetricDatum> metricData) {
        this.stageMetricDatum(metricName, counter.getCount(), DIMENSION_COUNT_TYPE_VALUE, StandardUnit.COUNT, timestampMilliSec, metricData);
    }

    private void stageMetricDatum(String metricName, double metricValue, String metricType, StandardUnit standardUnit, long timestampMilliSec, List<MetricDatum> metricData) {
        String[] metricNameParts = metricName.split("\\.", 2);
        String tableName = metricNameParts[0];
        metricData.add((MetricDatum)MetricDatum.builder().timestamp(Instant.ofEpochMilli(timestampMilliSec)).metricName(this.prefix(metricNameParts[1])).value(Double.valueOf(metricValue)).dimensions(this.getDimensions(tableName, metricType)).unit(standardUnit).build());
    }

    private List<Dimension> getDimensions(String tableName, String metricType) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        dimensions.add((Dimension)Dimension.builder().name(DIMENSION_TABLE_NAME_KEY).value(tableName).build());
        dimensions.add((Dimension)Dimension.builder().name(DIMENSION_METRIC_TYPE_KEY).value(metricType).build());
        return dimensions;
    }

    private String prefix(String ... components) {
        return MetricRegistry.name((String)this.prefix, (String[])components);
    }

    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.cloudWatchClientAsync.close();
            }
            catch (Exception ex) {
                LOG.warn("Exception while shutting down CloudWatch client.", (Throwable)ex);
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String namespace;
        private int maxDatumsPerRequest;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.maxDatumsPerRequest = 20;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder maxDatumsPerRequest(int maxDatumsPerRequest) {
            this.maxDatumsPerRequest = maxDatumsPerRequest;
            return this;
        }

        public CloudWatchReporter build(Properties props) {
            return new CloudWatchReporter(this.registry, CloudWatchReporter.getAmazonCloudWatchClient(props), this.clock, this.prefix, this.namespace, this.maxDatumsPerRequest, this.filter, this.rateUnit, this.durationUnit);
        }

        CloudWatchReporter build(CloudWatchAsyncClient amazonCloudWatchAsync) {
            return new CloudWatchReporter(this.registry, amazonCloudWatchAsync, this.clock, this.prefix, this.namespace, this.maxDatumsPerRequest, this.filter, this.rateUnit, this.durationUnit);
        }
    }
}

