/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class MetadataCommand
implements CommandMarker {
    private static final Logger LOG = LogManager.getLogger(MetadataCommand.class);
    private static String metadataBaseDirectory;
    private JavaSparkContext jsc;

    public static void setMetadataBaseDirectory(String metadataDir) {
        ValidationUtils.checkState((metadataBaseDirectory == null ? 1 : 0) != 0, (String)("metadataBaseDirectory is already set to " + metadataBaseDirectory));
        metadataBaseDirectory = metadataDir;
    }

    public static String getMetadataTableBasePath(String tableBasePath) {
        if (metadataBaseDirectory != null) {
            return metadataBaseDirectory;
        }
        return HoodieTableMetadata.getMetadataTableBasePath((String)tableBasePath);
    }

    @CliCommand(value={"metadata set"}, help="Set options for Metadata Table")
    public String set(@CliOption(key={"metadataDir"}, help="Directory to read/write metadata table (can be different from dataset)", unspecifiedDefaultValue="") String metadataDir) {
        if (!metadataDir.isEmpty()) {
            MetadataCommand.setMetadataBaseDirectory(metadataDir);
        }
        return "Ok";
    }

    @CliCommand(value={"metadata create"}, help="Create the Metadata Table if it does not exist")
    public String create() throws IOException {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            FileStatus[] statuses = HoodieCLI.fs.listStatus(metadataPath);
            if (statuses.length > 0) {
                throw new RuntimeException("Metadata directory (" + metadataPath.toString() + ") not empty.");
            }
        }
        catch (FileNotFoundException e) {
            HoodieCLI.fs.mkdirs(metadataPath);
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        HoodieWriteConfig writeConfig = this.getWriteConfig();
        this.initJavaSparkContext();
        SparkHoodieBackedTableMetadataWriter.create((Configuration)HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc));
        return String.format("Created Metadata Table in %s (duration=%.2f secs)", metadataPath, (double)timer.endTimer() / 1000.0);
    }

    @CliCommand(value={"metadata delete"}, help="Remove the Metadata Table")
    public String delete() throws Exception {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            FileStatus[] statuses = HoodieCLI.fs.listStatus(metadataPath);
            if (statuses.length > 0) {
                HoodieCLI.fs.delete(metadataPath, true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return String.format("Removed Metadata Table from %s", metadataPath);
    }

    @CliCommand(value={"metadata init"}, help="Update the metadata table from commits since the creation")
    public String init(@CliOption(key={"readonly"}, unspecifiedDefaultValue="false", help="Open in read-only mode") boolean readOnly) throws Exception {
        HoodieCLI.getTableMetaClient();
        Path metadataPath = new Path(MetadataCommand.getMetadataTableBasePath(HoodieCLI.basePath));
        try {
            HoodieCLI.fs.listStatus(metadataPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Metadata directory (" + metadataPath.toString() + ") does not exist.");
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        if (!readOnly) {
            HoodieWriteConfig writeConfig = this.getWriteConfig();
            this.initJavaSparkContext();
            SparkHoodieBackedTableMetadataWriter.create((Configuration)HoodieCLI.conf, (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc));
        }
        String action = readOnly ? "Opened" : "Initialized";
        return String.format(action + " Metadata Table in %s (duration=%.2fsec)", metadataPath, (double)timer.endTimer() / 1000.0);
    }

    @CliCommand(value={"metadata stats"}, help="Print stats about the metadata")
    public String stats() throws IOException {
        HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), config, HoodieCLI.basePath, "/tmp");
        Map stats = metadata.stats();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : stats.entrySet()) {
            Comparable[] row = new Comparable[]{(Comparable)entry.getKey(), (Comparable)entry.getValue()};
            rows.add(row);
        }
        TableHeader header = new TableHeader().addTableHeaderField("stat key").addTableHeaderField("stat value");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
    }

    @CliCommand(value={"metadata list-partitions"}, help="List all partitions from metadata")
    public String listPartitions() throws IOException {
        HoodieCLI.getTableMetaClient();
        this.initJavaSparkContext();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadata = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc), config, HoodieCLI.basePath, "/tmp");
        if (!metadata.enabled()) {
            return "[ERROR] Metadata Table not enabled/initialized\n\n";
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        List partitions = metadata.getAllPartitionPaths();
        LOG.debug((Object)("Took " + timer.endTimer() + " ms"));
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        partitions.stream().sorted(Comparator.reverseOrder()).forEach(p -> {
            Comparable[] row = new Comparable[]{p};
            rows.add(row);
        });
        TableHeader header = new TableHeader().addTableHeaderField("partition");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
    }

    @CliCommand(value={"metadata list-files"}, help="Print a list of all files in a partition from the metadata")
    public String listFiles(@CliOption(key={"partition"}, help="Name of the partition to list files", mandatory=true) String partition) throws IOException {
        HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metaReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), config, HoodieCLI.basePath, "/tmp");
        if (!metaReader.enabled()) {
            return "[ERROR] Metadata Table not enabled/initialized\n\n";
        }
        HoodieTimer timer = new HoodieTimer().startTimer();
        FileStatus[] statuses = metaReader.getAllFilesInPartition(new Path(HoodieCLI.basePath, partition));
        LOG.debug((Object)("Took " + timer.endTimer() + " ms"));
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        Arrays.stream(statuses).sorted((p1, p2) -> p2.getPath().getName().compareTo(p1.getPath().getName())).forEach(f -> {
            Comparable[] row = new Comparable[]{f};
            rows.add(row);
        });
        TableHeader header = new TableHeader().addTableHeaderField("file path");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
    }

    @CliCommand(value={"metadata validate-files"}, help="Validate all files in all partitions from the metadata")
    public String validateFiles(@CliOption(key={"verbose"}, help="Print all file details", unspecifiedDefaultValue="false") boolean verbose) throws IOException {
        HoodieCLI.getTableMetaClient();
        HoodieMetadataConfig config = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieBackedTableMetadata metadataReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), config, HoodieCLI.basePath, "/tmp");
        if (!metadataReader.enabled()) {
            return "[ERROR] Metadata Table not enabled/initialized\n\n";
        }
        HoodieMetadataConfig fsConfig = HoodieMetadataConfig.newBuilder().enable(false).build();
        HoodieBackedTableMetadata fsMetaReader = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HoodieCLI.conf), fsConfig, HoodieCLI.basePath, "/tmp");
        HoodieTimer timer = new HoodieTimer().startTimer();
        List metadataPartitions = metadataReader.getAllPartitionPaths();
        LOG.debug((Object)("Listing partitions Took " + timer.endTimer() + " ms"));
        List fsPartitions = fsMetaReader.getAllPartitionPaths();
        Collections.sort(fsPartitions);
        Collections.sort(metadataPartitions);
        HashSet allPartitions = new HashSet();
        allPartitions.addAll(fsPartitions);
        allPartitions.addAll(metadataPartitions);
        if (!fsPartitions.equals(metadataPartitions)) {
            LOG.error((Object)"FS partition listing is not matching with metadata partition listing!");
            LOG.error((Object)("All FS partitions: " + Arrays.toString(fsPartitions.toArray())));
            LOG.error((Object)("All Metadata partitions: " + Arrays.toString(metadataPartitions.toArray())));
        }
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (String partition : allPartitions) {
            HashMap fileStatusMap = new HashMap();
            HashMap metadataFileStatusMap = new HashMap();
            FileStatus[] metadataStatuses = metadataReader.getAllFilesInPartition(new Path(HoodieCLI.basePath, partition));
            Arrays.stream(metadataStatuses).forEach(entry -> metadataFileStatusMap.put(entry.getPath().getName(), entry));
            FileStatus[] fsStatuses = fsMetaReader.getAllFilesInPartition(new Path(HoodieCLI.basePath, partition));
            Arrays.stream(fsStatuses).forEach(entry -> fileStatusMap.put(entry.getPath().getName(), entry));
            HashSet allFiles = new HashSet();
            allFiles.addAll(fileStatusMap.keySet());
            allFiles.addAll(metadataFileStatusMap.keySet());
            for (String string : allFiles) {
                Comparable[] row = new Comparable[6];
                row[0] = partition;
                FileStatus fsFileStatus = (FileStatus)fileStatusMap.get(string);
                FileStatus metaFileStatus = (FileStatus)metadataFileStatusMap.get(string);
                row[1] = string;
                row[2] = Boolean.valueOf(fsFileStatus != null);
                row[3] = Boolean.valueOf(metaFileStatus != null);
                row[4] = Long.valueOf(fsFileStatus != null ? fsFileStatus.getLen() : 0L);
                row[5] = Long.valueOf(metaFileStatus != null ? metaFileStatus.getLen() : 0L);
                rows.add(row);
            }
            if (metadataStatuses.length != fsStatuses.length) {
                LOG.error((Object)(" FS and metadata files count not matching for " + partition + ". FS files count " + fsStatuses.length + ", metadata base files count " + metadataStatuses.length));
            }
            for (Map.Entry entry2 : fileStatusMap.entrySet()) {
                if (!metadataFileStatusMap.containsKey(entry2.getKey())) {
                    LOG.error((Object)("FS file not found in metadata " + (String)entry2.getKey()));
                    continue;
                }
                if (((FileStatus)entry2.getValue()).getLen() == ((FileStatus)metadataFileStatusMap.get(entry2.getKey())).getLen()) continue;
                LOG.error((Object)(" FS file size mismatch " + (String)entry2.getKey() + ", size equality " + (((FileStatus)entry2.getValue()).getLen() == ((FileStatus)metadataFileStatusMap.get(entry2.getKey())).getLen()) + ". FS size " + ((FileStatus)entry2.getValue()).getLen() + ", metadata size " + ((FileStatus)metadataFileStatusMap.get(entry2.getKey())).getLen()));
            }
            for (Map.Entry entry3 : metadataFileStatusMap.entrySet()) {
                if (!fileStatusMap.containsKey(entry3.getKey())) {
                    LOG.error((Object)("Metadata file not found in FS " + (String)entry3.getKey()));
                    continue;
                }
                if (((FileStatus)entry3.getValue()).getLen() == ((FileStatus)fileStatusMap.get(entry3.getKey())).getLen()) continue;
                LOG.error((Object)(" Metadata file size mismatch " + (String)entry3.getKey() + ", size equality " + (((FileStatus)entry3.getValue()).getLen() == ((FileStatus)fileStatusMap.get(entry3.getKey())).getLen()) + ". Metadata size " + ((FileStatus)entry3.getValue()).getLen() + ", FS size " + ((FileStatus)metadataFileStatusMap.get(entry3.getKey())).getLen()));
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition").addTableHeaderField("File Name").addTableHeaderField(" IsPresent in FS ").addTableHeaderField(" IsPresent in Metadata").addTableHeaderField(" FS size").addTableHeaderField(" Metadata size");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, Integer.MAX_VALUE, false, rows);
    }

    private HoodieWriteConfig getWriteConfig() {
        return HoodieWriteConfig.newBuilder().withPath(HoodieCLI.basePath).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(true).build()).build();
    }

    private void initJavaSparkContext() {
        if (this.jsc == null) {
            this.jsc = SparkUtil.initJavaSparkConf(SparkUtil.getDefaultConf("HoodieCLI", (Option<String>)Option.empty()));
        }
    }
}

