/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;

public class CommitUtil {
    public static long countNewRecords(HoodieTableMetaClient target, List<String> commitsToCatchup) throws IOException {
        long totalNew = 0L;
        HoodieTimeline timeline = target.reloadActiveTimeline().getCommitTimeline().filterCompletedInstants();
        for (String commit : commitsToCatchup) {
            HoodieCommitMetadata c = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(new HoodieInstant(false, "commit", commit)).get()), HoodieCommitMetadata.class);
            totalNew += c.fetchTotalRecordsWritten() - c.fetchTotalUpdateRecordsWritten();
        }
        return totalNew;
    }

    public static String getTimeDaysAgo(int numberOfDays) {
        Date date = Date.from(ZonedDateTime.now().minusDays(numberOfDays).toInstant());
        return HoodieActiveTimeline.formatDate((Date)date);
    }

    public static String addHours(String compactionCommitTime, int hours) throws ParseException {
        Instant instant = HoodieActiveTimeline.parseDateFromInstantTime((String)compactionCommitTime).toInstant();
        ZonedDateTime commitDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        return HoodieActiveTimeline.formatDate((Date)Date.from(commitDateTime.plusHours(hours).toInstant()));
    }
}

