/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class MarkersCommand
implements CommandMarker {
    @CliCommand(value={"marker delete"}, help="Delete the marker")
    public String deleteMarker(@CliOption(key={"commit"}, help="Delete a marker") String instantTime, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="1G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DELETE_MARKER.toString(), master, sparkMemory, instantTime, metaClient.getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not delete marker \"%s\".", instantTime);
        }
        return String.format("Marker \"%s\" deleted.", instantTime);
    }
}

