/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class UpgradeOrDowngradeCommand
implements CommandMarker {
    @CliCommand(value={"upgrade table"}, help="Upgrades a table")
    public String upgradeHoodieTable(@CliOption(key={"toVersion"}, help="To version of Hoodie table to be upgraded/downgraded to", unspecifiedDefaultValue="") String toVersion, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.UPGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersion});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie table to \"%s\".", toVersion);
        }
        return String.format("Hoodie table upgraded/downgraded to %s", toVersion);
    }

    @CliCommand(value={"downgrade table"}, help="Downgrades a table")
    public String downgradeHoodieTable(@CliOption(key={"toVersion"}, help="To version of Hoodie table to be upgraded/downgraded to", unspecifiedDefaultValue="") String toVersion, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DOWNGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersion});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie table to \"%s\".", toVersion);
        }
        return String.format("Hoodie table upgraded/downgraded to %s", toVersion);
    }
}

