/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class KerberosAuthenticationCommand {
    @ShellMethod(key={"kerberos kinit"}, value="Perform Kerberos authentication")
    public String performKerberosAuthentication(@ShellOption(value={"--krb5conf"}, help="Path to krb5.conf", defaultValue="/etc/krb5.conf") String krb5ConfPath, @ShellOption(value={"--principal"}, help="Kerberos principal") String principal, @ShellOption(value={"--keytab"}, help="Path to keytab") String keytabPath) throws IOException {
        System.out.println("Perform Kerberos authentication");
        System.out.println("Parameters:");
        System.out.println("--krb5conf: " + krb5ConfPath);
        System.out.println("--principal: " + principal);
        System.out.println("--keytab: " + keytabPath);
        System.setProperty("java.security.krb5.conf", krb5ConfPath);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("keytab.file", keytabPath);
        conf.set("kerberos.principal", principal);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabPath);
        System.out.println("Kerberos current user: " + UserGroupInformation.getCurrentUser());
        System.out.println("Kerberos login user: " + UserGroupInformation.getLoginUser());
        return "Kerberos authentication success";
    }
}

