/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class TableCommand {
    private static final Logger LOG = LogManager.getLogger(TableCommand.class);

    @ShellMethod(key={"connect"}, value="Connect to a hoodie table")
    public String connect(@ShellOption(value={"--path"}, help="Base Path of the table") String path, @ShellOption(value={"--layoutVersion"}, help="Timeline Layout version", defaultValue="__NULL__") Integer layoutVersion, @ShellOption(value={"--eventuallyConsistent"}, defaultValue="false", help="Enable eventual consistency") boolean eventuallyConsistent, @ShellOption(value={"--initialCheckIntervalMs"}, defaultValue="2000", help="Initial wait time for eventual consistency") Integer initialConsistencyIntervalMs, @ShellOption(value={"--maxWaitIntervalMs"}, defaultValue="300000", help="Max wait time for eventual consistency") Integer maxConsistencyIntervalMs, @ShellOption(value={"--maxCheckIntervalMs"}, defaultValue="7", help="Max checks for eventual consistency") Integer maxConsistencyChecks) throws IOException {
        HoodieCLI.setConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(eventuallyConsistent).withInitialConsistencyCheckIntervalMs(initialConsistencyIntervalMs.intValue()).withMaxConsistencyCheckIntervalMs(maxConsistencyIntervalMs.intValue()).withMaxConsistencyChecks(maxConsistencyChecks.intValue()).build());
        HoodieCLI.initConf();
        HoodieCLI.connectTo(path, layoutVersion);
        HoodieCLI.initFS(true);
        HoodieCLI.state = HoodieCLI.CLIState.TABLE;
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " loaded";
    }

    @ShellMethod(key={"create"}, value="Create a hoodie table if not present")
    public String createTable(@ShellOption(value={"--path"}, help="Base Path of the table") String path, @ShellOption(value={"--tableName"}, help="Hoodie Table Name") String name, @ShellOption(value={"--tableType"}, defaultValue="COPY_ON_WRITE", help="Hoodie Table Type. Must be one of : COPY_ON_WRITE or MERGE_ON_READ") String tableTypeStr, @ShellOption(value={"--archiveLogFolder"}, help="Folder Name for storing archived timeline", defaultValue="__NULL__") String archiveFolder, @ShellOption(value={"--layoutVersion"}, help="Specific Layout Version to use", defaultValue="__NULL__") Integer layoutVersion, @ShellOption(value={"--payloadClass"}, defaultValue="org.apache.hudi.common.model.HoodieAvroPayload", help="Payload Class") String payloadClass) throws IOException {
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        boolean existing = false;
        try {
            HoodieTableMetaClient.builder().setConf(HoodieCLI.conf).setBasePath(path).build();
            existing = true;
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        if (existing) {
            throw new IllegalStateException("Table already existing in path : " + path);
        }
        HoodieTableMetaClient.withPropertyBuilder().setTableType(tableTypeStr).setTableName(name).setArchiveLogFolder(archiveFolder).setPayloadClassName(payloadClass).setTimelineLayoutVersion(layoutVersion).initTable(HoodieCLI.conf, path);
        return this.connect(path, layoutVersion, false, 0, 0, 0);
    }

    @ShellMethod(key={"desc"}, value="Describe Hoodie Table properties")
    public String descTable() {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        TableHeader header = new TableHeader().addTableHeaderField("Property").addTableHeaderField("Value");
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{"basePath", client.getBasePath()});
        rows.add(new Comparable[]{"metaPath", client.getMetaPath()});
        rows.add(new Comparable[]{"fileSystem", client.getFs().getScheme()});
        client.getTableConfig().propsMap().entrySet().forEach(e -> rows.add(new Comparable[]{(Comparable)e.getKey(), (Comparable)e.getValue()}));
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, -1, false, rows);
    }

    @ShellMethod(key={"refresh", "metadata refresh", "commits refresh", "cleans refresh", "savepoints refresh"}, value="Refresh table metadata")
    public String refreshMetadata() {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " refreshed.";
    }

    @ShellMethod(key={"fetch table schema"}, value="Fetches latest table schema")
    public String fetchTableSchema(@ShellOption(value={"--outputFilePath"}, defaultValue="__NULL__", help="File path to write schema") String outputFilePath) throws Exception {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(client);
        Schema schema = tableSchemaResolver.getTableAvroSchema();
        if (outputFilePath != null) {
            LOG.info("Latest table schema : " + schema.toString(true));
            TableCommand.writeToFile(outputFilePath, schema.toString(true));
            return String.format("Latest table schema written to %s", outputFilePath);
        }
        return String.format("Latest table schema %s", schema.toString(true));
    }

    @ShellMethod(key={"table recover-configs"}, value="Recover table configs, from update/delete that failed midway.")
    public String recoverTableConfig() throws IOException {
        HoodieCLI.refreshTableMetadata();
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Path metaPathDir = new Path(client.getBasePath(), ".hoodie");
        HoodieTableConfig.recover((FileSystem)client.getFs(), (Path)metaPathDir);
        return this.descTable();
    }

    @ShellMethod(key={"table update-configs"}, value="Update the table configs with configs with provided file.")
    public String updateTableConfig(@ShellOption(value={"--props-file"}, help="Path to a properties file on local filesystem") String updatePropsFilePath) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Map oldProps = client.getTableConfig().propsMap();
        Properties updatedProps = new Properties();
        updatedProps.load(new FileInputStream(updatePropsFilePath));
        Path metaPathDir = new Path(client.getBasePath(), ".hoodie");
        HoodieTableConfig.update((FileSystem)client.getFs(), (Path)metaPathDir, (Properties)updatedProps);
        HoodieCLI.refreshTableMetadata();
        Map newProps = HoodieCLI.getTableMetaClient().getTableConfig().propsMap();
        return TableCommand.renderOldNewProps(newProps, oldProps);
    }

    @ShellMethod(key={"table delete-configs"}, value="Delete the supplied table configs from the table.")
    public String deleteTableConfig(@ShellOption(value={"--comma-separated-configs"}, help="Comma separated list of configs to delete.") String csConfigs) {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Map oldProps = client.getTableConfig().propsMap();
        Set deleteConfigs = Arrays.stream(csConfigs.split(",")).collect(Collectors.toSet());
        Path metaPathDir = new Path(client.getBasePath(), ".hoodie");
        HoodieTableConfig.delete((FileSystem)client.getFs(), (Path)metaPathDir, deleteConfigs);
        HoodieCLI.refreshTableMetadata();
        Map newProps = HoodieCLI.getTableMetaClient().getTableConfig().propsMap();
        return TableCommand.renderOldNewProps(newProps, oldProps);
    }

    private static String renderOldNewProps(Map<String, String> newProps, Map<String, String> oldProps) {
        TreeSet<String> allPropKeys = new TreeSet<String>();
        allPropKeys.addAll(newProps.keySet().stream().map(Object::toString).collect(Collectors.toSet()));
        allPropKeys.addAll(oldProps.keySet());
        String[][] rows = new String[allPropKeys.size()][];
        int ind = 0;
        for (String propKey : allPropKeys) {
            String[] row = new String[]{propKey, oldProps.getOrDefault(propKey, "null"), newProps.getOrDefault(propKey, "null")};
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Property", "Old Value", "New Value"}, rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filePath, String data) throws IOException {
        File outFile = new File(filePath);
        if (outFile.exists()) {
            outFile.delete();
        }
        try (OutputStream os = null;){
            os = new FileOutputStream(outFile);
            os.write(data.getBytes(), 0, data.length());
        }
    }

    static {
        System.out.println("Table command getting loaded");
    }
}

