/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.exception.HoodieException;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class TempViewCommand {
    public static final String QUERY_SUCCESS = "Query ran successfully!";
    public static final String QUERY_FAIL = "Query ran failed!";
    public static final String SHOW_SUCCESS = "Show all views name successfully!";

    @ShellMethod(key={"temp_query", "temp query"}, value="query against created temp view")
    public String query(@ShellOption(value={"--sql"}, help="select query to run against view") String sql) {
        try {
            HoodieCLI.getTempViewProvider().runQuery(sql);
            return QUERY_SUCCESS;
        }
        catch (HoodieException ex) {
            return QUERY_FAIL;
        }
    }

    @ShellMethod(key={"temps_show", "temps show"}, value="Show all views name")
    public String showAll() {
        try {
            HoodieCLI.getTempViewProvider().showAllViews();
            return SHOW_SUCCESS;
        }
        catch (HoodieException ex) {
            return "Show all views name failed!";
        }
    }

    @ShellMethod(key={"temp_delete", "temp delete"}, value="Delete view name")
    public String delete(@ShellOption(value={"--view"}, help="view name") String tableName) {
        try {
            HoodieCLI.getTempViewProvider().deleteTable(tableName);
            return String.format("Delete view %s successfully!", tableName);
        }
        catch (HoodieException ex) {
            return String.format("Delete view %s failed!", tableName);
        }
    }
}

