/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class UpgradeOrDowngradeCommand {
    @ShellMethod(key={"upgrade table"}, value="Upgrades a table")
    public String upgradeHoodieTable(@ShellOption(value={"--toVersion"}, help="To version of Hoodie table to be upgraded/downgraded to", defaultValue="") String toVersion, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String toVersionName = UpgradeOrDowngradeCommand.getHoodieTableVersionName(toVersion, true);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.UPGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersionName});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie table to \"%s\".", toVersionName);
        }
        return String.format("Hoodie table upgraded/downgraded to %s", toVersionName);
    }

    @ShellMethod(key={"downgrade table"}, value="Downgrades a table")
    public String downgradeHoodieTable(@ShellOption(value={"--toVersion"}, help="To version of Hoodie table to be upgraded/downgraded to", defaultValue="") String toVersion, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String toVersionName = UpgradeOrDowngradeCommand.getHoodieTableVersionName(toVersion, false);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DOWNGRADE.toString(), master, sparkMemory, metaClient.getBasePath(), toVersionName});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not Upgrade/Downgrade Hoodie table to \"%s\".", toVersionName);
        }
        return String.format("Hoodie table upgraded/downgraded to %s", toVersionName);
    }

    static String getHoodieTableVersionName(String versionOption, boolean overrideWithDefault) {
        if (StringUtils.isNullOrEmpty((String)versionOption) && overrideWithDefault) {
            return HoodieTableVersion.current().name();
        }
        try {
            int versionCode = Integer.parseInt(versionOption);
            return HoodieTableVersion.versionFromCode((int)versionCode).name();
        }
        catch (NumberFormatException e) {
            return versionOption;
        }
    }
}

