/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.DeDupeType$;
import org.apache.hudi.cli.SparkHelper;
import org.apache.hudi.cli.SparkHelpers$;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\t\u0013\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t]\u0001\u0011\t\u0011)A\u0005G!Aq\u0006\u0001B\u0001B\u0003%1\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b-\u0003A\u0011\u0001'\t\u000fQ\u0003!\u0019!C\u0001+\"1\u0011\f\u0001Q\u0001\nYCqA\u0017\u0001C\u0002\u0013\u00051\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t)\u0003\u0001C\u0001\u0003OA\u0011\"!\u000f\u0001#\u0003%\t!a\u000f\u0003\u001d\u0011+G-\u001e9f'B\f'o\u001b&pE*\u00111\u0003F\u0001\u0004G2L'BA\u000b\u0017\u0003\u0011AW\u000fZ5\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\tE\u0006\u001cX\rU1uQB\u0011Ae\u000b\b\u0003K%\u0002\"A\n\u0010\u000e\u0003\u001dR!\u0001\u000b\u000e\u0002\rq\u0012xn\u001c;?\u0013\tQc$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016\u001f\u0003]!W\u000f\u001d7jG\u0006$X\r\u001a)beRLG/[8o!\u0006$\b.\u0001\tsKB\f\u0017N](viB,H\u000fU1uQ\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014aA:rY*\u0011aGF\u0001\u0006gB\f'o[\u0005\u0003qM\u0012!bU)M\u0007>tG/\u001a=u\u0003\t17\u000f\u0005\u0002<\u007f5\tAH\u0003\u0002:{)\u0011aHF\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0001c$A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006QA-\u001a3va\u0016$\u0016\u0010]3\u0011\u0005\r;eB\u0001#F\u001b\u0005\u0011\u0012B\u0001$\u0013\u0003)!U\rR;qKRK\b/Z\u0005\u0003\u0011&\u0013QAV1mk\u0016L!A\u0013\u0010\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5su\nU)S'B\u0011A\t\u0001\u0005\u0006E\u001d\u0001\ra\t\u0005\u0006]\u001d\u0001\ra\t\u0005\u0006_\u001d\u0001\ra\t\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006s\u001d\u0001\rA\u000f\u0005\u0006\u0003\u001e\u0001\rAQ\u0001\fgB\f'o\u001b%fYB,'/F\u0001W!\t!u+\u0003\u0002Y%\tY1\u000b]1sW\"+G\u000e]3s\u00031\u0019\b/\u0019:l\u0011\u0016d\u0007/\u001a:!\u0003\raujR\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0006Y><GG\u001b\u0006\u0003CZ\tq\u0001\\8hO&tw-\u0003\u0002d=\n1Aj\\4hKJ\fA\u0001T(HA\u0005aq-\u001a;EkB,7*Z=E\rR\u0011qM\u001e\t\u0003QNt!![9\u000f\u0005)\u0004hBA6p\u001d\tagN\u0004\u0002'[&\t\u0011$\u0003\u0002\u00181%\u0011aGF\u0005\u0003iUJ!A]\u001a\u0002\u000fA\f7m[1hK&\u0011A/\u001e\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!A]\u001a\t\u000b]d\u0001\u0019A\u0012\u0002\u000fQ\u0014GNT1nK\u0006\u0001\u0002\u000f\\1o\tV\u0004H.[2bi\u00164\u0015\u000e\u001f\u000b\u0002uB110!\u0001$\u0003\u000bi\u0011\u0001 \u0006\u0003{z\fq!\\;uC\ndWM\u0003\u0002\u0000=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\rAPA\u0004ICNDW*\u00199\u0011\tm\f9aI\u0005\u0004\u0003\u0013a(a\u0002%bg\"\u001cV\r^\u0001\u000eO\u0016$H)\u001a3va\u0016\u0004F.\u00198\u0015\u0007i\fy\u0001C\u0004\u0002\u00129\u0001\r!a\u0005\u0002\u000f\u0011,\b/Z'baB1A%!\u0006$\u00033I1!a\u0006.\u0005\ri\u0015\r\u001d\t\u0006w\u0006m\u0011qD\u0005\u0004\u0003;a(A\u0002\"vM\u001a,'\u000fE\u00023\u0003CI1!a\t4\u0005\r\u0011vn^\u0001\u000eM&DH)\u001e9mS\u000e\fG/Z:\u0015\t\u0005%\u0012q\u0006\t\u0004;\u0005-\u0012bAA\u0017=\t!QK\\5u\u0011%\t\td\u0004I\u0001\u0002\u0004\t\u0019$\u0001\u0004eef\u0014VO\u001c\t\u0004;\u0005U\u0012bAA\u001c=\t9!i\\8mK\u0006t\u0017a\u00064jq\u0012+\b\u000f\\5dCR,7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiD\u000b\u0003\u00024\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-c$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DedupeSparkJob {
    private final String basePath;
    private final String duplicatedPartitionPath;
    private final String repairOutputPath;
    private final SQLContext sqlContext;
    private final FileSystem fs;
    private final Enumeration.Value dedupeType;
    private final SparkHelper sparkHelper;
    private final Logger LOG;

    public SparkHelper sparkHelper() {
        return this.sparkHelper;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public Dataset<Row> getDupeKeyDF(String tblName) {
        String dupeSql = new StringBuilder(156).append("\n      select  `").append("_hoodie_record_key").append("` as dupe_key,\n      count(*) as dupe_cnt\n      from ").append(tblName).append("\n      group by `").append("_hoodie_record_key").append("`\n      having dupe_cnt > 1\n      ").toString();
        return this.sqlContext.sql(dupeSql);
    }

    private HashMap<String, HashSet<String>> planDuplicateFix() {
        String tmpTableName = new StringBuilder(5).append("htbl_").append(System.currentTimeMillis()).toString();
        String dedupeTblName = new StringBuilder(9).append(tmpTableName).append("_dupeKeys").toString();
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.fs.getConf()).setBasePath(this.basePath).build();
        FileStatus[] allFiles = this.fs.listStatus(new Path(new StringBuilder(1).append(this.basePath).append("/").append(this.duplicatedPartitionPath).toString()));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Buffer filteredStatuses = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(latestFiles).map((Function1 & Serializable & scala.Serializable)f -> f.getPath(), Buffer$.MODULE$.canBuildFrom());
        this.LOG().info(new StringBuilder(37).append(" List of files under partition: ").append(BoxedUnit.UNIT).append(" =>  ").append(filteredStatuses.mkString(" ")).toString());
        Dataset df = this.sqlContext.parquetFile((Seq)filteredStatuses);
        df.registerTempTable(tmpTableName);
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF(tmpTableName);
        dupeKeyDF.registerTempTable(dedupeTblName);
        String dupeDataSql = new StringBuilder(208).append("\n        SELECT `_hoodie_record_key`, `_hoodie_partition_path`, `_hoodie_file_name`, `_hoodie_commit_time`\n        FROM ").append(tmpTableName).append(" h\n        JOIN ").append(dedupeTblName).append(" d\n        ON h.`_hoodie_record_key` = d.dupe_key\n                      ").toString();
        Map dupeMap = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.sqlContext.sql(dupeDataSql).collectAsList()).groupBy((Function1 & Serializable & scala.Serializable)r -> r.getString(0));
        return this.getDedupePlan((Map<String, Buffer<Row>>)dupeMap);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, HashSet<String>> getDedupePlan(Map<String, Buffer<Row>> dupeMap) {
        void var2_2;
        HashMap fileToDeleteKeyMap = new HashMap();
        dupeMap.foreach((Function1 & Serializable & scala.Serializable)rt -> {
            DedupeSparkJob.$anonfun$getDedupePlan$1(this, fileToDeleteKeyMap, rt);
            return BoxedUnit.UNIT;
        });
        this.LOG().debug(new StringBuilder(32).append("fileToDeleteKeyMap size: ").append(fileToDeleteKeyMap.size()).append(", map: ").append(fileToDeleteKeyMap).toString());
        return var2_2;
    }

    public void fixDuplicates(boolean dryRun) {
        Dataset<Row> fixedDF;
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.fs.getConf()).setBasePath(this.basePath).build();
        FileStatus[] allFiles = this.fs.listStatus(new Path(new StringBuilder(1).append(this.basePath).append("/").append(this.duplicatedPartitionPath).toString()));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Map fileNameToPathMap = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(latestFiles).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getFileId(), (Object)new Path(f.getPath())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap<String, HashSet<String>> dupeFixPlan = this.planDuplicateFix();
        fileNameToPathMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$fixDuplicates$2(this, dupeFixPlan, x0$1)));
        dupeFixPlan.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$fixDuplicates$3(this, fileNameToPathMap, dupeFixPlan, x0$2)));
        Dataset df = this.sqlContext.read().parquet(new StringBuilder(10).append(this.repairOutputPath).append("/*.parquet").toString());
        df.registerTempTable("fixedTbl");
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF("fixedTbl");
        long dupeCnt = dupeKeyDF.count();
        if (dupeCnt != 0L) {
            dupeKeyDF.show();
            throw new HoodieException("Still found some duplicates!!.. Inspect output");
        }
        Dataset<Row> sourceDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1 & Serializable & scala.Serializable)t -> ((Path)t._2()).toString(), Iterable$.MODULE$.canBuildFrom())).toList());
        Dataset missedRecordKeysDF = sourceDF.except(fixedDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(1).append($this.repairOutputPath).append("/").append(((Path)t._2()).getName()).toString(), Iterable$.MODULE$.canBuildFrom())).toList()));
        long missedCnt = missedRecordKeysDF.count();
        if (missedCnt != 0L) {
            missedRecordKeysDF.show();
            throw new HoodieException("Some records in source are not found in fixed files. Inspect output!!");
        }
        Predef$.MODULE$.println((Object)"No duplicates found & counts are in check!!!! ");
        fileNameToPathMap.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Object object;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Path filePath = (Path)tuple2._2();
                Path srcPath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(filePath.getName()).toString());
                Path dstPath = new Path(new StringBuilder(2).append($this.basePath).append("/").append($this.duplicatedPartitionPath).append("/").append(filePath.getName()).toString());
                if (dryRun) {
                    this.LOG().info(new StringBuilder(35).append("[JUST KIDDING!!!] Copying from ").append(srcPath).append(" to ").append(dstPath).toString());
                    object = BoxedUnit.UNIT;
                } else {
                    this.LOG().info(new StringBuilder(31).append("[FOR REAL!!!] Copying from ").append(srcPath).append(" to ").append(dstPath).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)FileUtil.copy((FileSystem)$this.fs, (Path)srcPath, (FileSystem)$this.fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)$this.fs.getConf()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    public boolean fixDuplicates$default$1() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getDedupePlan$2(HashMap fileToDeleteKeyMap$1, String key$1, Row r) {
        String f;
        block0: {
            f = ((String)r.apply(2)).split("_")[0];
            if (fileToDeleteKeyMap$1.contains((Object)f)) break block0;
            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return ((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key$1);
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$3(LongRef maxCommit$1, Row r) {
        block0: {
            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
            if (c <= maxCommit$1.elem) break block0;
            maxCommit$1.elem = c;
        }
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$5(LongRef maxCommit$2, Row r) {
        block0: {
            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
            if (c <= maxCommit$2.elem) break block0;
            maxCommit$2.elem = c;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDedupePlan$7(HashMap fileToDeleteKeyMap$1, String key$1, Row r) {
        String f;
        block0: {
            f = ((String)r.apply(2)).split("_")[0];
            if (fileToDeleteKeyMap$1.contains((Object)f)) break block0;
            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return ((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key$1);
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$1(DedupeSparkJob $this, HashMap fileToDeleteKeyMap$1, Tuple2 rt) {
        Tuple2 tuple2 = rt;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Buffer rows = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)key, (Object)rows);
        Tuple2 tuple23 = tuple22;
        String key2 = (String)tuple23._1();
        Buffer rows2 = (Buffer)tuple23._2();
        Enumeration.Value value = $this.dedupeType;
        Enumeration.Value value2 = DeDupeType$.MODULE$.UPDATE_TYPE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ((IterableLike)rows2.init()).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$getDedupePlan$2(fileToDeleteKeyMap$1, key2, r)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DeDupeType$.MODULE$.INSERT_TYPE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                LongRef maxCommit = LongRef.create((long)-1L);
                rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    DedupeSparkJob.$anonfun$getDedupePlan$3(maxCommit, r);
                    return BoxedUnit.UNIT;
                });
                rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    Object object;
                    long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                    if (c != maxCommit$1.elem) {
                        String f = ((String)r.apply(2)).split("_")[0];
                        if (!fileToDeleteKeyMap$1.contains((Object)f)) {
                            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DeDupeType$.MODULE$.UPSERT_TYPE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    LongRef maxCommit = LongRef.create((long)-1L);
                    rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                        DedupeSparkJob.$anonfun$getDedupePlan$5(maxCommit, r);
                        return BoxedUnit.UNIT;
                    });
                    ListBuffer rowsWithMaxCommit = new ListBuffer();
                    rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                        Object object;
                        long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                        if (c != maxCommit$2.elem) {
                            String f = ((String)r.apply(2)).split("_")[0];
                            if (!fileToDeleteKeyMap$1.contains((Object)f)) {
                                fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key2));
                        } else {
                            object = rowsWithMaxCommit.$plus$eq(r);
                        }
                        return object;
                    });
                    ((List)rowsWithMaxCommit.toList().init()).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$getDedupePlan$7(fileToDeleteKeyMap$1, key2, r)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new IllegalArgumentException("Please provide valid type for deduping!");
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$fixDuplicates$2(DedupeSparkJob $this, HashMap dupeFixPlan$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        Path filePath = (Path)tuple2._2();
        String badSuffix = dupeFixPlan$1.contains((Object)fileName) ? ".bad" : "";
        Path dstPath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(filePath.getName()).append(badSuffix).toString());
        $this.LOG().info(new StringBuilder(17).append("Copying from ").append(filePath).append(" to ").append(dstPath).toString());
        boolean bl = FileUtil.copy((FileSystem)$this.fs, (Path)filePath, (FileSystem)$this.fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)$this.fs.getConf());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fixDuplicates$3(DedupeSparkJob $this, Map fileNameToPathMap$1, HashMap dupeFixPlan$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        String instantTime = FSUtils.getCommitTime((String)((Path)fileNameToPathMap$1.apply((Object)fileName)).getName());
        Path badFilePath = new Path(new StringBuilder(5).append($this.repairOutputPath).append("/").append(((Path)fileNameToPathMap$1.apply((Object)fileName)).getName()).append(".bad").toString());
        Path newFilePath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(((Path)fileNameToPathMap$1.apply((Object)fileName)).getName()).toString());
        $this.LOG().info(new StringBuilder(37).append(" Skipping and writing new file for : ").append(fileName).toString());
        SparkHelpers$.MODULE$.skipKeysAndWriteNewFile(instantTime, $this.fs, badFilePath, newFilePath, (Set<String>)((Set)dupeFixPlan$1.apply((Object)fileName)));
        boolean bl = $this.fs.delete(badFilePath, true);
        return bl;
    }

    public DedupeSparkJob(String basePath, String duplicatedPartitionPath, String repairOutputPath, SQLContext sqlContext, FileSystem fs, Enumeration.Value dedupeType) {
        this.basePath = basePath;
        this.duplicatedPartitionPath = duplicatedPartitionPath;
        this.repairOutputPath = repairOutputPath;
        this.sqlContext = sqlContext;
        this.fs = fs;
        this.dedupeType = dedupeType;
        this.sparkHelper = new SparkHelper(sqlContext, fs);
        this.LOG = LogManager.getLogger(this.getClass());
    }
}

