/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.collection.JavaConverters;
import scala.collection.Map;

@ShellComponent
public class CleansCommand {
    @ShellMethod(key={"cleans show"}, value="Show the cleans")
    public String showCleans(@ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCleanerTimeline().filterCompletedInstants();
        List cleans = timeline.getReverseOrderedInstants().collect(Collectors.toList());
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (HoodieInstant clean : cleans) {
            HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])timeline.getInstantDetails(clean).get()));
            rows.add(new Comparable[]{clean.getTimestamp(), cleanMetadata.getEarliestCommitToRetain(), cleanMetadata.getTotalFilesDeleted(), cleanMetadata.getTimeTakenInMillis()});
        }
        TableHeader header = new TableHeader().addTableHeaderField("CleanTime").addTableHeaderField("EarliestCommandRetained").addTableHeaderField("Total Files Deleted").addTableHeaderField("Total Time Taken");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @ShellMethod(key={"clean showpartitions"}, value="Show partition level details of a clean")
    public String showCleanPartitions(@ShellOption(value={"--clean"}, help="clean to show") String instantTime, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="-1") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant cleanInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCleanerTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(cleanInstant = new HoodieInstant(false, "clean", instantTime))) {
            return "Clean " + instantTime + " not found in metadata " + timeline;
        }
        HoodieCleanMetadata cleanMetadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])timeline.getInstantDetails(cleanInstant).get()));
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : cleanMetadata.getPartitionMetadata().entrySet()) {
            String path = (String)entry.getKey();
            HoodieCleanPartitionMetadata stats = (HoodieCleanPartitionMetadata)entry.getValue();
            String policy = stats.getPolicy();
            int totalSuccessDeletedFiles = stats.getSuccessDeleteFiles().size();
            int totalFailedDeletedFiles = stats.getFailedDeleteFiles().size();
            rows.add(new Comparable[]{path, policy, Integer.valueOf(totalSuccessDeletedFiles), Integer.valueOf(totalFailedDeletedFiles)});
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("Cleaning policy").addTableHeaderField("Total Files Successfully Deleted").addTableHeaderField("Total Failed Deletions");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @ShellMethod(key={"cleans run"}, value="run clean")
    public String runClean(@ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory, @ShellOption(value={"--propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for cleaning", defaultValue="") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", defaultValue="") String[] configs, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master ") String master) throws IOException, InterruptedException, URISyntaxException {
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String cmd = SparkMain.SparkCommand.CLEAN.toString();
        sparkLauncher.addAppArgs(new String[]{cmd, master, sparkMemory, metaClient.getBasePath(), propsFilePath});
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to clean hoodie dataset";
        }
        return "Cleaned hoodie dataset";
    }
}

