/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class ExportCommand {
    @ShellMethod(key={"export instants"}, value="Export Instants and their metadata from the Timeline")
    public String exportInstants(@ShellOption(value={"--limit"}, help="Limit Instants", defaultValue="-1") Integer limit, @ShellOption(value={"--actions"}, help="Comma separated list of Instant actions to export", defaultValue="clean,commit,deltacommit,rollback,savepoint,restore") String filter, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--localFolder"}, help="Local Folder to export to") String localFolder) throws Exception {
        String basePath = HoodieCLI.getTableMetaClient().getBasePath();
        Path archivePath = new Path(basePath + "/.hoodie/.commits_.archive*");
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(filter.split(",")));
        int numExports = limit == -1 ? Integer.MAX_VALUE : limit;
        int numCopied = 0;
        if (!new File(localFolder).isDirectory()) {
            throw new HoodieException(localFolder + " is not a valid local directory");
        }
        HoodieTimeline timeline = HoodieCLI.getTableMetaClient().getActiveTimeline().filterCompletedInstants().filter(i -> actionSet.contains(i.getAction()));
        List nonArchivedInstants = timeline.getInstants();
        FileStatus[] statuses = FSUtils.getFs((String)basePath, (Configuration)HoodieCLI.conf).globStatus(archivePath);
        List<FileStatus> archivedStatuses = Arrays.stream(statuses).sorted((f1, f2) -> (int)(f1.getModificationTime() - f2.getModificationTime())).collect(Collectors.toList());
        if (descending) {
            Collections.reverse(nonArchivedInstants);
            numCopied = this.copyNonArchivedInstants(nonArchivedInstants, numExports, localFolder);
            if (numCopied < numExports) {
                Collections.reverse(archivedStatuses);
                numCopied += this.copyArchivedInstants(archivedStatuses, actionSet, numExports - numCopied, localFolder);
            }
        } else {
            numCopied = this.copyArchivedInstants(archivedStatuses, actionSet, numExports, localFolder);
            if (numCopied < numExports) {
                numCopied += this.copyNonArchivedInstants(nonArchivedInstants, numExports - numCopied, localFolder);
            }
        }
        return "Exported " + numCopied + " Instants to " + localFolder;
    }

    private int copyArchivedInstants(List<FileStatus> statuses, Set<String> actionSet, int limit, String localFolder) throws Exception {
        int copyCount = 0;
        FileSystem fileSystem = FSUtils.getFs((String)HoodieCLI.getTableMetaClient().getBasePath(), (Configuration)HoodieCLI.conf);
        for (FileStatus fs : statuses) {
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((FileSystem)fileSystem, (HoodieLogFile)new HoodieLogFile(fs.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            block25: while (reader.hasNext() && copyCount < limit) {
                HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                ClosableIterator recordItr = blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                Throwable throwable = null;
                try {
                    while (recordItr.hasNext()) {
                        IndexedRecord ir = (IndexedRecord)((HoodieRecord)recordItr.next()).getData();
                        HoodieArchivedMetaEntry archiveEntryRecord = (HoodieArchivedMetaEntry)SpecificData.get().deepCopy(HoodieArchivedMetaEntry.SCHEMA$, (Object)ir);
                        String action = archiveEntryRecord.get("actionType").toString();
                        if (!actionSet.contains(action)) continue;
                        HoodieCleanMetadata metadata = null;
                        switch (action) {
                            case "clean": {
                                metadata = archiveEntryRecord.getHoodieCleanMetadata();
                                break;
                            }
                            case "commit": 
                            case "deltacommit": {
                                metadata = archiveEntryRecord.getHoodieCommitMetadata();
                                break;
                            }
                            case "rollback": {
                                metadata = archiveEntryRecord.getHoodieRollbackMetadata();
                                break;
                            }
                            case "savepoint": {
                                metadata = archiveEntryRecord.getHoodieSavePointMetadata();
                                break;
                            }
                            case "compaction": {
                                metadata = archiveEntryRecord.getHoodieCompactionMetadata();
                                break;
                            }
                            default: {
                                throw new HoodieException("Unknown type of action " + action);
                            }
                        }
                        String instantTime = archiveEntryRecord.get("commitTime").toString();
                        String outPath = localFolder + "/" + instantTime + "." + action;
                        this.writeToFile(outPath, HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true));
                        if (++copyCount != limit) continue;
                        continue block25;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (recordItr == null) continue;
                    if (throwable != null) {
                        try {
                            recordItr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    recordItr.close();
                }
            }
            reader.close();
        }
        return copyCount;
    }

    private int copyNonArchivedInstants(List<HoodieInstant> instants, int limit, String localFolder) throws Exception {
        int copyCount = 0;
        if (instants.isEmpty()) {
            return copyCount;
        }
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline();
        for (HoodieInstant instant : instants) {
            String localPath = localFolder + "/" + instant.getFileName();
            byte[] data = null;
            switch (instant.getAction()) {
                case "clean": {
                    HoodieCleanMetadata metadata = TimelineMetadataUtils.deserializeHoodieCleanMetadata((byte[])((byte[])timeline.getInstantDetails(instant).get()));
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                case "deltacommit": 
                case "commit": 
                case "compaction": {
                    data = (byte[])timeline.getInstantDetails(instant).get();
                    break;
                }
                case "rollback": {
                    HoodieCleanMetadata metadata = TimelineMetadataUtils.deserializeHoodieRollbackMetadata((byte[])((byte[])timeline.getInstantDetails(instant).get()));
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                case "savepoint": {
                    HoodieCleanMetadata metadata = TimelineMetadataUtils.deserializeHoodieSavepointMetadata((byte[])((byte[])timeline.getInstantDetails(instant).get()));
                    data = HoodieAvroUtils.avroToJson((GenericRecord)metadata, (boolean)true);
                    break;
                }
                default: {
                    throw new HoodieException("Unknown type of action " + instant.getAction());
                }
            }
            if (data == null) continue;
            this.writeToFile(localPath, data);
            ++copyCount;
        }
        return copyCount;
    }

    private void writeToFile(String path, byte[] data) throws Exception {
        FileOutputStream writer = new FileOutputStream(path);
        writer.write(data);
        writer.close();
    }
}

