/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.utilities.HDFSParquetImporter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import scala.collection.JavaConverters;
import scala.collection.Map;

@Component
public class HDFSParquetImportCommand
implements CommandMarker {
    private static Logger log = LogManager.getLogger(HDFSParquetImportCommand.class);

    @CliCommand(value={"hdfsparquetimport"}, help="Imports Parquet dataset to a hoodie dataset")
    public String convert(@CliOption(key={"upsert"}, mandatory=false, unspecifiedDefaultValue="false", help="Uses upsert API instead of the default insert API of WriteClient") boolean useUpsert, @CliOption(key={"srcPath"}, mandatory=true, help="Base path for the input dataset") String srcPath, @CliOption(key={"targetPath"}, mandatory=true, help="Base path for the target hoodie dataset") String targetPath, @CliOption(key={"tableName"}, mandatory=true, help="Table name") String tableName, @CliOption(key={"tableType"}, mandatory=true, help="Table type") String tableType, @CliOption(key={"rowKeyField"}, mandatory=true, help="Row key field name") String rowKeyField, @CliOption(key={"partitionPathField"}, mandatory=true, help="Partition path field name") String partitionPathField, @CliOption(key={"parallelism"}, mandatory=true, help="Parallelism for hoodie insert") String parallelism, @CliOption(key={"schemaFilePath"}, mandatory=true, help="Path for Avro schema file") String schemaFilePath, @CliOption(key={"format"}, mandatory=true, help="Format for the input data") String format, @CliOption(key={"sparkMemory"}, mandatory=true, help="Spark executor memory") String sparkMemory, @CliOption(key={"retry"}, mandatory=true, help="Number of retries") String retry) throws Exception {
        new HDFSParquetImporter.FormatValidator().validate("format", format);
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String cmd = SparkMain.SparkCommand.IMPORT.toString();
        if (useUpsert) {
            cmd = SparkMain.SparkCommand.UPSERT.toString();
        }
        sparkLauncher.addAppArgs(new String[]{cmd, srcPath, targetPath, tableName, tableType, rowKeyField, partitionPathField, parallelism, schemaFilePath, sparkMemory, retry});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to import dataset to hoodie format";
        }
        return "Dataset imported to hoodie format";
    }
}

