/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.joda.time.DateTime;

public class HiveUtil {
    private static final String driverName = "org.apache.hive.jdbc.HiveDriver";

    private static Connection getConnection(String jdbcUrl, String user, String pass) throws SQLException {
        return DriverManager.getConnection(jdbcUrl, user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countRecords(String jdbcUrl, HoodieTableMetaClient source, String dbName, String user, String pass) throws SQLException {
        Connection conn = HiveUtil.getConnection(jdbcUrl, user, pass);
        ResultSet rs = null;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery("select count(`_hoodie_commit_time`) as cnt from " + dbName + "." + source.getTableConfig().getTableName());
            long count = -1L;
            if (rs.next()) {
                count = rs.getLong("cnt");
            }
            System.out.println("Total records in " + source.getTableConfig().getTableName() + " is " + count);
            long l = count;
            return l;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, int partitions, String user, String pass) throws SQLException {
        DateTime dateTime = DateTime.now();
        String endDateStr = dateTime.getYear() + "-" + String.format("%02d", dateTime.getMonthOfYear()) + "-" + String.format("%02d", dateTime.getDayOfMonth());
        dateTime = dateTime.minusDays(partitions);
        String startDateStr = dateTime.getYear() + "-" + String.format("%02d", dateTime.getMonthOfYear()) + "-" + String.format("%02d", dateTime.getDayOfMonth());
        System.out.println("Start date " + startDateStr + " and end date " + endDateStr);
        return HiveUtil.countRecords(jdbcUrl, source, srcDb, startDateStr, endDateStr, user, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long countRecords(String jdbcUrl, HoodieTableMetaClient source, String srcDb, String startDateStr, String endDateStr, String user, String pass) throws SQLException {
        Connection conn = HiveUtil.getConnection(jdbcUrl, user, pass);
        ResultSet rs = null;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("set hive.input.format=org.apache.hadoop.hive.ql.io.HiveInputFormat");
            stmt.execute("set hive.stats.autogather=false");
            rs = stmt.executeQuery("select count(`_hoodie_commit_time`) as cnt from " + srcDb + "." + source.getTableConfig().getTableName() + " where datestr>'" + startDateStr + "' and datestr<='" + endDateStr + "'");
            if (rs.next()) {
                long l = rs.getLong("cnt");
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    static {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find org.apache.hive.jdbc.HiveDriver in classpath. ", e);
        }
    }
}

