/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;

public class SparkUtil {
    public static Logger logger = Logger.getLogger(SparkUtil.class);
    public static final String DEFUALT_SPARK_MASTER = "yarn-client";

    public static SparkLauncher initLauncher(String propertiesFile) throws URISyntaxException {
        String currentJar = new File(SparkUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        SparkLauncher sparkLauncher = new SparkLauncher().setAppResource(currentJar).setMainClass(SparkMain.class.getName());
        if (!StringUtils.isNullOrEmpty((String)propertiesFile)) {
            sparkLauncher.setPropertiesFile(propertiesFile);
        }
        File libDirectory = new File(new File(currentJar).getParent(), "lib");
        for (String library : libDirectory.list()) {
            sparkLauncher.addJar(new File(libDirectory, library).getAbsolutePath());
        }
        return sparkLauncher;
    }

    public static JavaSparkContext initJavaSparkConf(String name) {
        SparkConf sparkConf = new SparkConf().setAppName(name);
        String defMasterFromEnv = sparkConf.get("spark.master");
        if (null == defMasterFromEnv || defMasterFromEnv.isEmpty()) {
            sparkConf.setMaster(DEFUALT_SPARK_MASTER);
        }
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.eventLog.overwrite", "true");
        sparkConf.set("spark.eventLog.enabled", "true");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        sparkConf = HoodieWriteClient.registerClasses((SparkConf)sparkConf);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        jsc.hadoopConfiguration().setBoolean("parquet.enable.summary-metadata", false);
        FSUtils.prepareHadoopConf((Configuration)jsc.hadoopConfiguration());
        return jsc;
    }
}

