/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import com.jakewharton.fliptables.FlipTable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hudi.cli.Table;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.util.Option;

public class HoodiePrintHelper {
    public static String print(String[] header, String[][] rows) {
        return HoodiePrintHelper.printTextTable(header, rows);
    }

    public static String print(TableHeader rowHeader, Map<String, Function<Object, String>> fieldNameToConverterMap, String sortByField, boolean isDescending, Integer limit, boolean headerOnly, List<Comparable[]> rows) {
        if (headerOnly) {
            return HoodiePrintHelper.print(rowHeader);
        }
        if (!sortByField.isEmpty() && !rowHeader.containsField(sortByField)) {
            return String.format("Field[%s] is not in table, given columns[%s]", sortByField, rowHeader.getFieldNames());
        }
        Table table = new Table(rowHeader, fieldNameToConverterMap, (Option<String>)Option.ofNullable((Object)(sortByField.isEmpty() ? null : sortByField)), (Option<Boolean>)Option.ofNullable((Object)isDescending), (Option<Integer>)Option.ofNullable((Object)(limit <= 0 ? null : limit))).addAllRows(rows).flip();
        return HoodiePrintHelper.print(table);
    }

    private static String print(Table buffer) {
        String[] header = new String[buffer.getFieldNames().size()];
        buffer.getFieldNames().toArray(header);
        String[][] rows = (String[][])buffer.getRenderRows().stream().map(l -> l.toArray(new String[l.size()])).toArray(x$0 -> new String[x$0][]);
        return HoodiePrintHelper.printTextTable(header, rows);
    }

    private static String print(TableHeader header) {
        String[] head = new String[header.getFieldNames().size()];
        header.getFieldNames().toArray(head);
        return HoodiePrintHelper.printTextTable(head, new String[0][]);
    }

    private static String printTextTable(String[] headers, String[][] data) {
        return FlipTable.of((String[])headers, (String[][])data);
    }
}

