/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CommitsCommand
implements CommandMarker {
    @CliCommand(value={"commits show"}, help="Show the commits")
    public String showCommits(@CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        List commits = timeline.getReverseOrderedInstants().collect(Collectors.toList());
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (HoodieInstant commit : commits) {
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            rows.add(new Comparable[]{commit.getTimestamp(), Long.valueOf(commitMetadata.fetchTotalBytesWritten()), Long.valueOf(commitMetadata.fetchTotalFilesInsert()), Long.valueOf(commitMetadata.fetchTotalFilesUpdated()), Long.valueOf(commitMetadata.fetchTotalPartitionsWritten()), Long.valueOf(commitMetadata.fetchTotalRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalUpdateRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalWriteErrors())});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Files Added").addTableHeaderField("Total Files Updated").addTableHeaderField("Total Partitions Written").addTableHeaderField("Total Records Written").addTableHeaderField("Total Update Records Written").addTableHeaderField("Total Errors");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"commits refresh"}, help="Refresh the commits")
    public String refreshCommits() throws IOException {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " refreshed.";
    }

    @CliCommand(value={"commit rollback"}, help="Rollback a commit")
    public String rollbackCommit(@CliOption(key={"commit"}, help="Commit to rollback") String commitTime, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath) throws Exception {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline filteredTimeline = completedTimeline.filter(instant -> instant.getTimestamp().equals(commitTime));
        if (filteredTimeline.empty()) {
            return "Commit " + commitTime + " not found in Commits " + completedTimeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.ROLLBACK.toString(), commitTime, HoodieCLI.getTableMetaClient().getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        this.refreshCommits();
        if (exitCode != 0) {
            return "Commit " + commitTime + " failed to roll back";
        }
        return "Commit " + commitTime + " rolled back";
    }

    @CliCommand(value={"commit showpartitions"}, help="Show partition level details of a commit")
    public String showCommitPartitions(@CliOption(key={"commit"}, help="Commit to show") String commitTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", commitTime))) {
            return "Commit " + commitTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(commitInstant).get()), HoodieCommitMetadata.class);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry2 : meta.getPartitionToWriteStats().entrySet()) {
            String path = (String)entry2.getKey();
            List stats = (List)entry2.getValue();
            long totalFilesAdded = 0L;
            long totalFilesUpdated = 0L;
            long totalRecordsUpdated = 0L;
            long totalRecordsInserted = 0L;
            long totalBytesWritten = 0L;
            long totalWriteErrors = 0L;
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit().equals("null")) {
                    ++totalFilesAdded;
                    totalRecordsInserted += stat.getNumWrites();
                } else {
                    ++totalFilesUpdated;
                    totalRecordsUpdated += stat.getNumUpdateWrites();
                }
                totalBytesWritten += stat.getTotalWriteBytes();
                totalWriteErrors += stat.getTotalWriteErrors();
            }
            rows.add(new Comparable[]{path, Long.valueOf(totalFilesAdded), Long.valueOf(totalFilesUpdated), Long.valueOf(totalRecordsInserted), Long.valueOf(totalRecordsUpdated), Long.valueOf(totalBytesWritten), Long.valueOf(totalWriteErrors)});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Long.parseLong(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("Total Files Added").addTableHeaderField("Total Files Updated").addTableHeaderField("Total Records Inserted").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"commit showfiles"}, help="Show file level details of a commit")
    public String showCommitFiles(@CliOption(key={"commit"}, help="Commit to show") String commitTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", commitTime))) {
            return "Commit " + commitTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(commitInstant).get()), HoodieCommitMetadata.class);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : meta.getPartitionToWriteStats().entrySet()) {
            String path = (String)entry.getKey();
            List stats = (List)entry.getValue();
            for (HoodieWriteStat stat : stats) {
                rows.add(new Comparable[]{path, stat.getFileId(), stat.getPrevCommit(), Long.valueOf(stat.getNumUpdateWrites()), Long.valueOf(stat.getNumWrites()), Long.valueOf(stat.getTotalWriteBytes()), Long.valueOf(stat.getTotalWriteErrors()), Long.valueOf(stat.getFileSizeInBytes())});
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("File ID").addTableHeaderField("Previous Commit").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Records Written").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors").addTableHeaderField("File Size");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"commits compare"}, help="Compare commits with another Hoodie table")
    public String compareCommits(@CliOption(key={"path"}, help="Path of the table to compare to") String path) throws Exception {
        String sourceLatestCommit;
        HoodieTableMetaClient source = HoodieCLI.getTableMetaClient();
        HoodieTableMetaClient target = new HoodieTableMetaClient(HoodieCLI.conf, path);
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? "0" : ((HoodieInstant)targetTimeline.lastInstant().get()).getTimestamp();
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? "0" : ((HoodieInstant)sourceTimeline.lastInstant().get()).getTimestamp();
        if (sourceLatestCommit != null && HoodieTimeline.compareTimestamps((String)targetLatestCommit, (String)sourceLatestCommit, (BiPredicate)HoodieTimeline.GREATER)) {
            List commitsToCatchup = targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
            return "Source " + source.getTableConfig().getTableName() + " is behind by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
        }
        List commitsToCatchup = sourceTimeline.findInstantsAfter(targetLatestCommit, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        return "Source " + source.getTableConfig().getTableName() + " is ahead by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
    }

    @CliCommand(value={"commits sync"}, help="Compare commits with another Hoodie table")
    public String syncCommits(@CliOption(key={"path"}, help="Path of the table to compare to") String path) {
        HoodieCLI.syncTableMetadata = new HoodieTableMetaClient(HoodieCLI.conf, path);
        HoodieCLI.state = HoodieCLI.CLIState.SYNC;
        return "Load sync state between " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " and " + HoodieCLI.syncTableMetadata.getTableConfig().getTableName();
    }
}

