/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.NumericUtils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class FileSystemViewCommand
implements CommandMarker {
    @CliCommand(value={"show fsview all"}, help="Show entire file-system view")
    public String showAllFileSlices(@CliOption(key={"pathRegex"}, help="regex to select files, eg: 2016/08/02", unspecifiedDefaultValue="*/*/*") String globRegex, @CliOption(key={"baseFileOnly"}, help="Only display base files view", unspecifiedDefaultValue="false") boolean baseFileOnly, @CliOption(key={"maxInstant"}, help="File-Slices upto this instant are displayed", unspecifiedDefaultValue="") String maxInstant, @CliOption(key={"includeMax"}, help="Include Max Instant", unspecifiedDefaultValue="false") boolean includeMaxInstant, @CliOption(key={"includeInflight"}, help="Include Inflight Instants", unspecifiedDefaultValue="false") boolean includeInflight, @CliOption(key={"excludeCompaction"}, help="Exclude compaction Instants", unspecifiedDefaultValue="false") boolean excludeCompaction, @CliOption(key={"limit"}, help="Limit rows to be displayed", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieTableFileSystemView fsView = this.buildFileSystemView(globRegex, maxInstant, baseFileOnly, includeMaxInstant, includeInflight, excludeCompaction);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        fsView.getAllFileGroups().forEach(fg -> fg.getAllFileSlices().forEach(fs -> {
            int idx = 0;
            Comparable[] row = new Comparable[baseFileOnly ? 5 : 8];
            row[idx++] = fg.getPartitionPath();
            row[idx++] = fg.getFileGroupId().getFileId();
            row[idx++] = fs.getBaseInstantTime();
            row[idx++] = fs.getBaseFile().isPresent() ? ((HoodieBaseFile)fs.getBaseFile().get()).getPath() : "";
            row[idx++] = Long.valueOf(fs.getBaseFile().isPresent() ? ((HoodieBaseFile)fs.getBaseFile().get()).getFileSize() : -1L);
            if (!baseFileOnly) {
                row[idx++] = Long.valueOf(fs.getLogFiles().count());
                row[idx++] = Long.valueOf(fs.getLogFiles().mapToLong(HoodieLogFile::getFileSize).sum());
                row[idx++] = fs.getLogFiles().collect(Collectors.toList()).toString();
            }
            rows.add(row);
        }));
        Function<Object, String> converterFunction = entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString()));
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Delta File Size", converterFunction);
        fieldNameToConverterMap.put("Data-File Size", converterFunction);
        TableHeader header = new TableHeader().addTableHeaderField("Partition").addTableHeaderField("FileId").addTableHeaderField("Base-Instant").addTableHeaderField("Data-File").addTableHeaderField("Data-File Size");
        if (!baseFileOnly) {
            header = header.addTableHeaderField("Num Delta Files").addTableHeaderField("Total Delta File Size").addTableHeaderField("Delta Files");
        }
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"show fsview latest"}, help="Show latest file-system view")
    public String showLatestFileSlices(@CliOption(key={"partitionPath"}, help="A valid paritition path", mandatory=true) String partition, @CliOption(key={"baseFileOnly"}, help="Only display base file view", unspecifiedDefaultValue="false") boolean baseFileOnly, @CliOption(key={"maxInstant"}, help="File-Slices upto this instant are displayed", unspecifiedDefaultValue="") String maxInstant, @CliOption(key={"merge"}, help="Merge File Slices due to pending compaction", unspecifiedDefaultValue="true") boolean merge, @CliOption(key={"includeMax"}, help="Include Max Instant", unspecifiedDefaultValue="false") boolean includeMaxInstant, @CliOption(key={"includeInflight"}, help="Include Inflight Instants", unspecifiedDefaultValue="false") boolean includeInflight, @CliOption(key={"excludeCompaction"}, help="Exclude compaction Instants", unspecifiedDefaultValue="false") boolean excludeCompaction, @CliOption(key={"limit"}, help="Limit rows to be displayed", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        Stream fileSliceStream;
        HoodieTableFileSystemView fsView = this.buildFileSystemView(partition, maxInstant, baseFileOnly, includeMaxInstant, includeInflight, excludeCompaction);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        if (!merge) {
            fileSliceStream = fsView.getLatestFileSlices(partition);
        } else {
            if (maxInstant.isEmpty()) {
                maxInstant = ((HoodieInstant)HoodieCLI.getTableMetaClient().getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant().get()).getTimestamp();
            }
            fileSliceStream = fsView.getLatestMergedFileSlicesBeforeOrOn(partition, maxInstant);
        }
        fileSliceStream.forEach(fs -> {
            int idx = 0;
            Comparable[] row = new Comparable[baseFileOnly ? 5 : 13];
            row[idx++] = partition;
            row[idx++] = fs.getFileId();
            row[idx++] = fs.getBaseInstantTime();
            row[idx++] = fs.getBaseFile().isPresent() ? ((HoodieBaseFile)fs.getBaseFile().get()).getPath() : "";
            long dataFileSize = fs.getBaseFile().isPresent() ? ((HoodieBaseFile)fs.getBaseFile().get()).getFileSize() : -1L;
            row[idx++] = Long.valueOf(dataFileSize);
            if (!baseFileOnly) {
                row[idx++] = Long.valueOf(fs.getLogFiles().count());
                row[idx++] = Long.valueOf(fs.getLogFiles().mapToLong(HoodieLogFile::getFileSize).sum());
                long logFilesScheduledForCompactionTotalSize = fs.getLogFiles().filter(lf -> lf.getBaseCommitTime().equals(fs.getBaseInstantTime())).mapToLong(HoodieLogFile::getFileSize).sum();
                row[idx++] = Long.valueOf(logFilesScheduledForCompactionTotalSize);
                long logFilesUnscheduledTotalSize = fs.getLogFiles().filter(lf -> !lf.getBaseCommitTime().equals(fs.getBaseInstantTime())).mapToLong(HoodieLogFile::getFileSize).sum();
                row[idx++] = Long.valueOf(logFilesUnscheduledTotalSize);
                double logSelectedForCompactionToBaseRatio = dataFileSize > 0L ? (double)logFilesScheduledForCompactionTotalSize / ((double)dataFileSize * 1.0) : -1.0;
                row[idx++] = Double.valueOf(logSelectedForCompactionToBaseRatio);
                double logUnscheduledToBaseRatio = dataFileSize > 0L ? (double)logFilesUnscheduledTotalSize / ((double)dataFileSize * 1.0) : -1.0;
                row[idx++] = Double.valueOf(logUnscheduledToBaseRatio);
                row[idx++] = fs.getLogFiles().filter(lf -> lf.getBaseCommitTime().equals(fs.getBaseInstantTime())).collect(Collectors.toList()).toString();
                row[idx++] = fs.getLogFiles().filter(lf -> !lf.getBaseCommitTime().equals(fs.getBaseInstantTime())).collect(Collectors.toList()).toString();
            }
            rows.add(row);
        });
        Function<Object, String> converterFunction = entry -> NumericUtils.humanReadableByteCount((double)Double.parseDouble(entry.toString()));
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Data-File Size", converterFunction);
        if (!baseFileOnly) {
            fieldNameToConverterMap.put("Total Delta Size", converterFunction);
            fieldNameToConverterMap.put("Delta Size - compaction scheduled", converterFunction);
            fieldNameToConverterMap.put("Delta Size - compaction unscheduled", converterFunction);
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition").addTableHeaderField("FileId").addTableHeaderField("Base-Instant").addTableHeaderField("Data-File").addTableHeaderField("Data-File Size");
        if (!baseFileOnly) {
            header = header.addTableHeaderField("Num Delta Files").addTableHeaderField("Total Delta Size").addTableHeaderField("Delta Size - compaction scheduled").addTableHeaderField("Delta Size - compaction unscheduled").addTableHeaderField("Delta To Base Ratio - compaction scheduled").addTableHeaderField("Delta To Base Ratio - compaction unscheduled").addTableHeaderField("Delta Files - compaction scheduled").addTableHeaderField("Delta Files - compaction unscheduled");
        }
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows);
    }

    private HoodieTableFileSystemView buildFileSystemView(String globRegex, String maxInstant, boolean basefileOnly, boolean includeMaxInstant, boolean includeInflight, boolean excludeCompaction) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(client.getHadoopConf(), client.getBasePath(), true);
        FileSystem fs = HoodieCLI.fs;
        String globPath = String.format("%s/%s/*", client.getBasePath(), globRegex);
        FileStatus[] statuses = fs.globStatus(new Path(globPath));
        HoodieTimeline timeline = basefileOnly ? metaClient.getActiveTimeline().getCommitTimeline() : (excludeCompaction ? metaClient.getActiveTimeline().getCommitsTimeline() : metaClient.getActiveTimeline().getCommitsAndCompactionTimeline());
        if (!includeInflight) {
            timeline = timeline.filterCompletedInstants();
        }
        Stream<HoodieInstant> instantsStream = timeline.getInstants();
        if (!maxInstant.isEmpty()) {
            BiPredicate predicate = includeMaxInstant ? HoodieTimeline.GREATER_OR_EQUAL : HoodieTimeline.GREATER;
            instantsStream = instantsStream.filter(is -> predicate.test(maxInstant, is.getTimestamp()));
        }
        HoodieDefaultTimeline filteredTimeline = new HoodieDefaultTimeline(instantsStream, arg_0 -> ((HoodieActiveTimeline)metaClient.getActiveTimeline()).getInstantDetails(arg_0));
        return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)filteredTimeline, statuses);
    }
}

