/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.cli.utils.HiveUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.exception.HoodieException;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class HoodieSyncCommand
implements CommandMarker {
    @CliCommand(value={"sync validate"}, help="Validate the sync by counting the number of records")
    public String validateSync(@CliOption(key={"mode"}, unspecifiedDefaultValue="complete", help="Check mode") String mode, @CliOption(key={"sourceDb"}, unspecifiedDefaultValue="rawdata", help="source database") String srcDb, @CliOption(key={"targetDb"}, unspecifiedDefaultValue="dwh_hoodie", help="target database") String tgtDb, @CliOption(key={"partitionCount"}, unspecifiedDefaultValue="5", help="total number of recent partitions to validate") int partitionCount, @CliOption(key={"hiveServerUrl"}, mandatory=true, help="hiveServerURL to connect to") String hiveServerUrl, @CliOption(key={"hiveUser"}, unspecifiedDefaultValue="", help="hive username to connect to") String hiveUser, @CliOption(key={"hivePass"}, mandatory=true, unspecifiedDefaultValue="", help="hive password to connect to") String hivePass) throws Exception {
        String sourceLatestCommit;
        if (HoodieCLI.syncTableMetadata == null) {
            throw new HoodieException("Sync validate request target table not null.");
        }
        HoodieTableMetaClient target = HoodieCLI.syncTableMetadata;
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline();
        HoodieTableMetaClient source = HoodieCLI.getTableMetaClient();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline();
        long sourceCount = 0L;
        long targetCount = 0L;
        if ("complete".equals(mode)) {
            sourceCount = HiveUtil.countRecords(hiveServerUrl, source, srcDb, hiveUser, hivePass);
            targetCount = HiveUtil.countRecords(hiveServerUrl, target, tgtDb, hiveUser, hivePass);
        } else if ("latestPartitions".equals(mode)) {
            sourceCount = HiveUtil.countRecords(hiveServerUrl, source, srcDb, partitionCount, hiveUser, hivePass);
            targetCount = HiveUtil.countRecords(hiveServerUrl, target, tgtDb, partitionCount, hiveUser, hivePass);
        }
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? "0" : ((HoodieInstant)targetTimeline.lastInstant().get()).getTimestamp();
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? "0" : ((HoodieInstant)sourceTimeline.lastInstant().get()).getTimestamp();
        if (sourceLatestCommit != null && HoodieTimeline.compareTimestamps((String)targetLatestCommit, (String)sourceLatestCommit, (BiPredicate)HoodieTimeline.GREATER)) {
            return this.getString(target, targetTimeline, source, sourceCount, targetCount, sourceLatestCommit);
        }
        return this.getString(source, sourceTimeline, target, targetCount, sourceCount, targetLatestCommit);
    }

    private String getString(HoodieTableMetaClient target, HoodieTimeline targetTimeline, HoodieTableMetaClient source, long sourceCount, long targetCount, String sourceLatestCommit) throws IOException {
        List commitsToCatchup = targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants().collect(Collectors.toList());
        if (commitsToCatchup.isEmpty()) {
            return "Count difference now is (count(" + target.getTableConfig().getTableName() + ") - count(" + source.getTableConfig().getTableName() + ") == " + (targetCount - sourceCount);
        }
        long newInserts = CommitUtil.countNewRecords(target, commitsToCatchup.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toList()));
        return "Count difference now is (count(" + target.getTableConfig().getTableName() + ") - count(" + source.getTableConfig().getTableName() + ") == " + (targetCount - sourceCount) + ". Catch up count is " + newInserts;
    }
}

