/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FSUtils;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RepairsCommand
implements CommandMarker {
    @CliCommand(value={"repair deduplicate"}, help="De-duplicate a partition path contains duplicates & produce repaired files to replace with")
    public String deduplicate(@CliOption(key={"duplicatedPartitionPath"}, help="Partition Path containing the duplicates", mandatory=true) String duplicatedPartitionPath, @CliOption(key={"repairedOutputPath"}, help="Location to place the repaired files", mandatory=true) String repairedOutputPath, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path", mandatory=true) String sparkPropertiesPath) throws Exception {
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.DEDUPLICATE.toString(), duplicatedPartitionPath, repairedOutputPath, HoodieCLI.getTableMetaClient().getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Deduplicated files placed in:  " + repairedOutputPath;
        }
        return "Deduplication failed ";
    }

    @CliCommand(value={"repair addpartitionmeta"}, help="Add partition metadata to a table, if not present")
    public String addPartitionMeta(@CliOption(key={"dryrun"}, help="Should we actually add or just print what would be done", unspecifiedDefaultValue="true") boolean dryRun) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        String latestCommit = ((HoodieInstant)client.getActiveTimeline().getCommitTimeline().lastInstant().get()).getTimestamp();
        List partitionPaths = FSUtils.getAllPartitionFoldersThreeLevelsDown((FileSystem)HoodieCLI.fs, (String)client.getBasePath());
        Path basePath = new Path(client.getBasePath());
        String[][] rows = new String[partitionPaths.size()][];
        int ind = 0;
        for (String partition : partitionPaths) {
            Path partitionPath = FSUtils.getPartitionPath((Path)basePath, (String)partition);
            String[] row = new String[]{partition, "Yes", "None"};
            if (!HoodiePartitionMetadata.hasPartitionMetadata((FileSystem)HoodieCLI.fs, (Path)partitionPath)) {
                row[1] = "No";
                if (!dryRun) {
                    HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(HoodieCLI.fs, latestCommit, basePath, partitionPath);
                    partitionMetadata.trySave(0);
                }
            }
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Partition Path", "Metadata Present?", "Action"}, rows);
    }

    @CliCommand(value={"repair overwrite-hoodie-props"}, help="Overwrite hoodie.properties with provided file. Risky operation. Proceed with caution!")
    public String overwriteHoodieProperties(@CliOption(key={"new-props-file"}, help="Path to a properties file on local filesystem to overwrite the table's hoodie.properties with") String overwriteFilePath) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Properties newProps = new Properties();
        newProps.load(new FileInputStream(new File(overwriteFilePath)));
        Map oldProps = client.getTableConfig().getProps();
        Path metaPathDir = new Path(client.getBasePath(), HoodieTableMetaClient.METAFOLDER_NAME);
        HoodieTableConfig.createHoodieProperties((FileSystem)client.getFs(), (Path)metaPathDir, (Properties)newProps);
        TreeSet allPropKeys = new TreeSet();
        allPropKeys.addAll(newProps.keySet().stream().map(Object::toString).collect(Collectors.toSet()));
        allPropKeys.addAll(oldProps.keySet());
        String[][] rows = new String[allPropKeys.size()][];
        int ind = 0;
        for (String propKey : allPropKeys) {
            String[] row = new String[]{propKey, oldProps.getOrDefault(propKey, "null"), newProps.getOrDefault((Object)propKey, "null").toString()};
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Property", "Old Value", "New Value"}, rows);
    }
}

