/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.cli.commands.SparkEnvCommand;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;

public class SparkUtil {
    public static final String DEFAULT_SPARK_MASTER = "yarn-client";

    public static SparkLauncher initLauncher(String propertiesFile) throws URISyntaxException {
        String currentJar = new File(SparkUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
        Map<String, String> env = SparkEnvCommand.env;
        SparkLauncher sparkLauncher = new SparkLauncher(env).setAppResource(currentJar).setMainClass(SparkMain.class.getName());
        if (!StringUtils.isNullOrEmpty((String)propertiesFile)) {
            sparkLauncher.setPropertiesFile(propertiesFile);
        }
        File libDirectory = new File(new File(currentJar).getParent(), "lib");
        for (String library : (String[])Preconditions.checkNotNull((Object)libDirectory.list())) {
            sparkLauncher.addJar(new File(libDirectory, library).getAbsolutePath());
        }
        return sparkLauncher;
    }

    public static JavaSparkContext initJavaSparkConf(String name) {
        SparkConf sparkConf = new SparkConf().setAppName(name);
        String defMasterFromEnv = sparkConf.getenv("SPARK_MASTER");
        if (null == defMasterFromEnv || defMasterFromEnv.isEmpty()) {
            sparkConf.setMaster(DEFAULT_SPARK_MASTER);
        } else {
            sparkConf.setMaster(defMasterFromEnv);
        }
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.driver.maxResultSize", "2g");
        sparkConf.set("spark.eventLog.overwrite", "true");
        sparkConf.set("spark.eventLog.enabled", "true");
        sparkConf.set("spark.hadoop.mapred.output.compress", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "true");
        sparkConf.set("spark.hadoop.mapred.output.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        sparkConf.set("spark.hadoop.mapred.output.compression.type", "BLOCK");
        HoodieWriteClient.registerClasses((SparkConf)sparkConf);
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        jsc.hadoopConfiguration().setBoolean("parquet.enable.summary-metadata", false);
        FSUtils.prepareHadoopConf((Configuration)jsc.hadoopConfiguration());
        return jsc;
    }
}

