/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.utilities.HDFSParquetImporter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;
import scala.collection.JavaConverters;
import scala.collection.Map;

@Component
public class HDFSParquetImportCommand
implements CommandMarker {
    @CliCommand(value={"hdfsparquetimport"}, help="Imports Parquet table to a hoodie table")
    public String convert(@CliOption(key={"upsert"}, unspecifiedDefaultValue="false", help="Uses upsert API instead of the default insert API of WriteClient") boolean useUpsert, @CliOption(key={"srcPath"}, mandatory=true, help="Base path for the input table") String srcPath, @CliOption(key={"targetPath"}, mandatory=true, help="Base path for the target hoodie table") String targetPath, @CliOption(key={"tableName"}, mandatory=true, help="Table name") String tableName, @CliOption(key={"tableType"}, mandatory=true, help="Table type") String tableType, @CliOption(key={"rowKeyField"}, mandatory=true, help="Row key field name") String rowKeyField, @CliOption(key={"partitionPathField"}, mandatory=true, help="Partition path field name") String partitionPathField, @CliOption(key={"parallelism"}, mandatory=true, help="Parallelism for hoodie insert") String parallelism, @CliOption(key={"schemaFilePath"}, mandatory=true, help="Path for Avro schema file") String schemaFilePath, @CliOption(key={"format"}, mandatory=true, help="Format for the input data") String format, @CliOption(key={"sparkMemory"}, mandatory=true, help="Spark executor memory") String sparkMemory, @CliOption(key={"retry"}, mandatory=true, help="Number of retries") String retry, @CliOption(key={"propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for importing", unspecifiedDefaultValue="") String propsFilePath, @CliOption(key={"hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", unspecifiedDefaultValue="") String[] configs) throws Exception {
        new HDFSParquetImporter.FormatValidator().validate("format", format);
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String cmd = SparkMain.SparkCommand.IMPORT.toString();
        if (useUpsert) {
            cmd = SparkMain.SparkCommand.UPSERT.toString();
        }
        sparkLauncher.addAppArgs(new String[]{cmd, srcPath, targetPath, tableName, tableType, rowKeyField, partitionPathField, parallelism, schemaFilePath, sparkMemory, retry, propsFilePath});
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to import table to hoodie format";
        }
        return "Table imported to hoodie format";
    }
}

