/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.TimelineLayoutVersion;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ConsistencyGuardConfig;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;

public class HoodieCLI {
    public static Configuration conf;
    public static ConsistencyGuardConfig consistencyGuardConfig;
    public static FileSystem fs;
    public static CLIState state;
    public static String basePath;
    protected static HoodieTableMetaClient tableMetadata;
    public static HoodieTableMetaClient syncTableMetadata;
    public static TimelineLayoutVersion layoutVersion;

    public static void setConsistencyGuardConfig(ConsistencyGuardConfig config) {
        consistencyGuardConfig = config;
    }

    private static void setTableMetaClient(HoodieTableMetaClient tableMetadata) {
        HoodieCLI.tableMetadata = tableMetadata;
    }

    private static void setBasePath(String basePath) {
        HoodieCLI.basePath = basePath;
    }

    private static void setLayoutVersion(Integer layoutVersion) {
        HoodieCLI.layoutVersion = new TimelineLayoutVersion(layoutVersion == null ? TimelineLayoutVersion.CURR_VERSION : layoutVersion);
    }

    public static boolean initConf() {
        if (conf == null) {
            conf = FSUtils.prepareHadoopConf((Configuration)new Configuration());
            return true;
        }
        return false;
    }

    public static void initFS(boolean force) throws IOException {
        if (fs == null || force) {
            fs = tableMetadata != null ? tableMetadata.getFs() : FileSystem.get((Configuration)conf);
        }
    }

    public static void refreshTableMetadata() {
        HoodieCLI.setTableMetaClient(new HoodieTableMetaClient(conf, basePath, false, consistencyGuardConfig, Option.of((Object)layoutVersion)));
    }

    public static void connectTo(String basePath, Integer layoutVersion) {
        HoodieCLI.setBasePath(basePath);
        HoodieCLI.setLayoutVersion(layoutVersion);
        HoodieCLI.refreshTableMetadata();
    }

    public static HoodieTableMetaClient getTableMetaClient() {
        if (tableMetadata == null) {
            throw new NullPointerException("There is no hudi table. Please use connect command to set table first");
        }
        return tableMetadata;
    }

    static {
        consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        state = CLIState.INIT;
    }

    public static enum CLIState {
        INIT,
        TABLE,
        SYNC;

    }
}

