/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class RollbacksCommand
implements CommandMarker {
    @CliCommand(value={"show rollbacks"}, help="List all rollback instants")
    public String showRollbacks(@CliOption(key={"limit"}, help="Limit #rows to be displayed", unspecifiedDefaultValue="10") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) {
        RollbackTimeline activeTimeline = new RollbackTimeline(HoodieCLI.getTableMetaClient());
        HoodieTimeline rollback = activeTimeline.getRollbackTimeline().filterCompletedInstants();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rollback.getInstants().forEach(instant -> {
            try {
                HoodieRollbackMetadata metadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])activeTimeline.getInstantDetails((HoodieInstant)instant).get()), HoodieRollbackMetadata.class);
                metadata.getCommitsRollback().forEach(c -> {
                    Comparable[] row = new Comparable[]{metadata.getStartRollbackTime(), c, metadata.getTotalFilesDeleted(), metadata.getTimeTakenInMillis(), Integer.valueOf(metadata.getPartitionMetadata() != null ? metadata.getPartitionMetadata().size() : 0)};
                    rows.add(row);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Rolledback Instant").addTableHeaderField("Total Files Deleted").addTableHeaderField("Time taken in millis").addTableHeaderField("Total Partitions");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @CliCommand(value={"show rollback"}, help="Show details of a rollback instant")
    public String showRollback(@CliOption(key={"instant"}, help="Rollback instant", mandatory=true) String rollbackInstant, @CliOption(key={"limit"}, help="Limit  #rows to be displayed", unspecifiedDefaultValue="10") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        RollbackTimeline activeTimeline = new RollbackTimeline(HoodieCLI.getTableMetaClient());
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        HoodieRollbackMetadata metadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])activeTimeline.getInstantDetails(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", rollbackInstant)).get()), HoodieRollbackMetadata.class);
        metadata.getPartitionMetadata().forEach((key, value) -> Stream.concat(value.getSuccessDeleteFiles().stream().map(f -> Pair.of((Object)f, (Object)true)), value.getFailedDeleteFiles().stream().map(f -> Pair.of((Object)f, (Object)false))).forEach(fileWithDeleteStatus -> {
            Comparable[] row = new Comparable[]{metadata.getStartRollbackTime(), metadata.getCommitsRollback().toString(), key, (Comparable)fileWithDeleteStatus.getLeft(), (Comparable)fileWithDeleteStatus.getRight()};
            rows.add(row);
        }));
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Rolledback Instant").addTableHeaderField("Partition").addTableHeaderField("Deleted File").addTableHeaderField("Succeeded");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    public static class RollbackTimeline
    extends HoodieActiveTimeline {
        public RollbackTimeline(HoodieTableMetaClient metaClient) {
            super(metaClient, CollectionUtils.createImmutableSet((Object[])new String[]{".rollback"}));
        }
    }
}

