/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.cli.utils.TempViewProvider;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;

public class SparkTempViewProvider
implements TempViewProvider {
    private static final Logger LOG = LogManager.getLogger(SparkTempViewProvider.class);
    private JavaSparkContext jsc;
    private SQLContext sqlContext;

    public SparkTempViewProvider(String appName) {
        try {
            SparkConf sparkConf = new SparkConf().setAppName(appName).set("spark.serializer", "org.apache.spark.serializer.KryoSerializer").setMaster("local[8]");
            this.jsc = new JavaSparkContext(sparkConf);
            this.jsc.setLogLevel("ERROR");
            this.sqlContext = new SQLContext(this.jsc);
        }
        catch (Throwable ex) {
            LOG.error((Object)"unable to initialize spark context ", ex);
            throw new HoodieException(ex);
        }
    }

    @Override
    public void createOrReplace(String tableName, List<String> headers, List<List<Comparable>> rows) {
        try {
            if (headers.isEmpty() || rows.isEmpty()) {
                return;
            }
            if (rows.stream().filter(row -> row.size() != headers.size()).count() > 0L) {
                throw new HoodieException("Invalid row, does not match headers " + headers.size() + " " + rows.size());
            }
            List headersNoSpaces = headers.stream().map(title -> title.replaceAll("\\s+", "")).collect(Collectors.toList());
            StructType structType = new StructType();
            for (int i = 0; i < headersNoSpaces.size(); ++i) {
                DataType headerDataType = this.getDataType(rows.get(0).get(i));
                structType = structType.add(DataTypes.createStructField((String)((String)headersNoSpaces.get(i)), (DataType)headerDataType, (boolean)true));
            }
            List records = rows.stream().map(row -> RowFactory.create((Object[])row.toArray(new Comparable[row.size()]))).collect(Collectors.toList());
            Dataset dataset = this.sqlContext.createDataFrame(records, structType);
            dataset.createOrReplaceTempView(tableName);
            System.out.println("Wrote table view: " + tableName);
        }
        catch (Throwable ex) {
            LOG.error((Object)"unable to write ", ex);
            throw new HoodieException(ex);
        }
    }

    @Override
    public void runQuery(String sqlText) {
        try {
            this.sqlContext.sql(sqlText).show(Integer.MAX_VALUE, false);
        }
        catch (Throwable ex) {
            LOG.error((Object)"unable to read ", ex);
            throw new HoodieException(ex);
        }
    }

    @Override
    public void showAllViews() {
        try {
            this.sqlContext.sql("SHOW TABLES").show(Integer.MAX_VALUE, false);
        }
        catch (Throwable ex) {
            LOG.error((Object)"unable to get all views ", ex);
            throw new HoodieException(ex);
        }
    }

    @Override
    public void deleteTable(String tableName) {
        try {
            this.sqlContext.sql("DROP TABLE IF EXISTS " + tableName);
        }
        catch (Throwable ex) {
            LOG.error((Object)"unable to initialize spark context ", ex);
            throw new HoodieException(ex);
        }
    }

    @Override
    public void close() {
        if (this.sqlContext != null) {
            this.sqlContext.sparkSession().stop();
        }
    }

    private DataType getDataType(Comparable comparable) {
        if (comparable instanceof Integer) {
            return DataTypes.IntegerType;
        }
        if (comparable instanceof Double) {
            return DataTypes.DoubleType;
        }
        if (comparable instanceof Long) {
            return DataTypes.LongType;
        }
        if (comparable instanceof Boolean) {
            return DataTypes.BooleanType;
        }
        return DataTypes.StringType;
    }
}

