/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.CommitUtil;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class CommitsCommand
implements CommandMarker {
    private String printCommits(HoodieDefaultTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName) throws IOException {
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        List commits = timeline.getCommitsTimeline().filterCompletedInstants().getInstants().collect(Collectors.toList());
        Collections.sort(commits, HoodieInstant.COMPARATOR.reversed());
        for (int i = 0; i < commits.size(); ++i) {
            HoodieInstant commit = (HoodieInstant)commits.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            rows.add(new Comparable[]{commit.getTimestamp(), Long.valueOf(commitMetadata.fetchTotalBytesWritten()), Long.valueOf(commitMetadata.fetchTotalFilesInsert()), Long.valueOf(commitMetadata.fetchTotalFilesUpdated()), Long.valueOf(commitMetadata.fetchTotalPartitionsWritten()), Long.valueOf(commitMetadata.fetchTotalRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalUpdateRecordsWritten()), Long.valueOf(commitMetadata.fetchTotalWriteErrors())});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.valueOf(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Files Added").addTableHeaderField("Total Files Updated").addTableHeaderField("Total Partitions Written").addTableHeaderField("Total Records Written").addTableHeaderField("Total Update Records Written").addTableHeaderField("Total Errors");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, tempTableName);
    }

    private String printCommitsWithMetadata(HoodieDefaultTimeline timeline, Integer limit, String sortByField, boolean descending, boolean headerOnly, String tempTableName) throws IOException {
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        List commits = timeline.getCommitsTimeline().filterCompletedInstants().getInstants().collect(Collectors.toList());
        Collections.sort(commits, HoodieInstant.COMPARATOR.reversed());
        for (int i = 0; i < commits.size(); ++i) {
            HoodieInstant commit = (HoodieInstant)commits.get(i);
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails(commit).get()), HoodieCommitMetadata.class);
            for (Map.Entry partitionWriteStat : commitMetadata.getPartitionToWriteStats().entrySet()) {
                for (HoodieWriteStat hoodieWriteStat : (List)partitionWriteStat.getValue()) {
                    rows.add(new Comparable[]{commit.getAction(), commit.getTimestamp(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), Long.valueOf(hoodieWriteStat.getNumWrites()), Long.valueOf(hoodieWriteStat.getNumInserts()), Long.valueOf(hoodieWriteStat.getNumDeletes()), Long.valueOf(hoodieWriteStat.getNumUpdateWrites()), Long.valueOf(hoodieWriteStat.getTotalWriteErrors()), Long.valueOf(hoodieWriteStat.getTotalLogBlocks()), Long.valueOf(hoodieWriteStat.getTotalCorruptLogBlock()), Long.valueOf(hoodieWriteStat.getTotalRollbackBlocks()), Long.valueOf(hoodieWriteStat.getTotalLogRecords()), Long.valueOf(hoodieWriteStat.getTotalUpdatedRecordsCompacted()), Long.valueOf(hoodieWriteStat.getTotalWriteBytes())});
                }
            }
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Double.valueOf(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Action").addTableHeaderField("Instant").addTableHeaderField("Partition").addTableHeaderField("FileId").addTableHeaderField("Previous Commit").addTableHeaderField("Num Writes").addTableHeaderField("Num Inserts").addTableHeaderField("Num Deletes").addTableHeaderField("Num Update Writes").addTableHeaderField("Total Errors").addTableHeaderField("Total Log Blocks").addTableHeaderField("Total Corrupt LogBlocks").addTableHeaderField("Total Rollback Blocks").addTableHeaderField("Total Log Records").addTableHeaderField("Total Updated Records Compacted").addTableHeaderField("Total Bytes Written");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows, tempTableName);
    }

    @CliCommand(value={"commits show"}, help="Show the commits")
    public String showCommits(@CliOption(key={"includeExtraMetadata"}, help="Include extra metadata", unspecifiedDefaultValue="false") boolean includeExtraMetadata, @CliOption(key={"createView"}, mandatory=false, help="view name to store output table", unspecifiedDefaultValue="") String exportTableName, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        if (includeExtraMetadata) {
            return this.printCommitsWithMetadata((HoodieDefaultTimeline)activeTimeline, limit, sortByField, descending, headerOnly, exportTableName);
        }
        return this.printCommits((HoodieDefaultTimeline)activeTimeline, limit, sortByField, descending, headerOnly, exportTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"commits showarchived"}, help="Show the archived commits")
    public String showArchivedCommits(@CliOption(key={"includeExtraMetadata"}, help="Include extra metadata", unspecifiedDefaultValue="false") boolean includeExtraMetadata, @CliOption(key={"createView"}, mandatory=false, help="view name to store output table", unspecifiedDefaultValue="") String exportTableName, @CliOption(key={"startTs"}, mandatory=false, help="start time for commits, default: now - 10 days") String startTs, @CliOption(key={"endTs"}, mandatory=false, help="end time for commits, default: now - 1 day") String endTs, @CliOption(key={"limit"}, mandatory=false, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws IOException {
        if (StringUtils.isNullOrEmpty((String)startTs)) {
            startTs = CommitUtil.getTimeDaysAgo(10);
        }
        if (StringUtils.isNullOrEmpty((String)endTs)) {
            endTs = CommitUtil.getTimeDaysAgo(1);
        }
        HoodieArchivedTimeline archivedTimeline = HoodieCLI.getTableMetaClient().getArchivedTimeline();
        try {
            archivedTimeline.loadInstantDetailsInMemory(startTs, endTs);
            HoodieDefaultTimeline timelineRange = archivedTimeline.findInstantsInRange(startTs, endTs);
            if (includeExtraMetadata) {
                String string = this.printCommitsWithMetadata(timelineRange, limit, sortByField, descending, headerOnly, exportTableName);
                return string;
            }
            String string = this.printCommits(timelineRange, limit, sortByField, descending, headerOnly, exportTableName);
            return string;
        }
        finally {
            archivedTimeline.clearInstantDetailsFromMemory(startTs, endTs);
        }
    }

    @CliCommand(value={"commit rollback"}, help="Rollback a commit")
    public String rollbackCommit(@CliOption(key={"commit"}, help="Commit to rollback") String instantTime, @CliOption(key={"sparkProperties"}, help="Spark Properties File Path") String sparkPropertiesPath, @CliOption(key={"sparkMaster"}, unspecifiedDefaultValue="", help="Spark Master") String master, @CliOption(key={"sparkMemory"}, unspecifiedDefaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline completedTimeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline filteredTimeline = completedTimeline.filter(instant -> instant.getTimestamp().equals(instantTime));
        if (filteredTimeline.empty()) {
            return "Commit " + instantTime + " not found in Commits " + completedTimeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.ROLLBACK.toString(), master, sparkMemory, instantTime, HoodieCLI.getTableMetaClient().getBasePath()});
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return "Commit " + instantTime + " failed to roll back";
        }
        return "Commit " + instantTime + " rolled back";
    }

    @CliCommand(value={"commit showpartitions"}, help="Show partition level details of a commit")
    public String showCommitPartitions(@CliOption(key={"createView"}, mandatory=false, help="view name to store output table", unspecifiedDefaultValue="") String exportTableName, @CliOption(key={"commit"}, help="Commit to show") String instantTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", instantTime))) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(commitInstant).get()), HoodieCommitMetadata.class);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry2 : meta.getPartitionToWriteStats().entrySet()) {
            String path = (String)entry2.getKey();
            List stats = (List)entry2.getValue();
            long totalFilesAdded = 0L;
            long totalFilesUpdated = 0L;
            long totalRecordsUpdated = 0L;
            long totalRecordsInserted = 0L;
            long totalBytesWritten = 0L;
            long totalWriteErrors = 0L;
            for (HoodieWriteStat stat : stats) {
                if (stat.getPrevCommit().equals("null")) {
                    ++totalFilesAdded;
                } else {
                    ++totalFilesUpdated;
                    totalRecordsUpdated += stat.getNumUpdateWrites();
                }
                totalRecordsInserted += stat.getNumInserts();
                totalBytesWritten += stat.getTotalWriteBytes();
                totalWriteErrors += stat.getTotalWriteErrors();
            }
            rows.add(new Comparable[]{path, Long.valueOf(totalFilesAdded), Long.valueOf(totalFilesUpdated), Long.valueOf(totalRecordsInserted), Long.valueOf(totalRecordsUpdated), Long.valueOf(totalBytesWritten), Long.valueOf(totalWriteErrors)});
        }
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Long.parseLong(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("Total Files Added").addTableHeaderField("Total Files Updated").addTableHeaderField("Total Records Inserted").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @CliCommand(value={"commit show_write_stats"}, help="Show write stats of a commit")
    public String showWriteStats(@CliOption(key={"createView"}, mandatory=false, help="view name to store output table", unspecifiedDefaultValue="") String exportTableName, @CliOption(key={"commit"}, help="Commit to show") String instantTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", instantTime))) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(commitInstant).get()), HoodieCommitMetadata.class);
        long recordsWritten = meta.fetchTotalRecordsWritten();
        long bytesWritten = meta.fetchTotalBytesWritten();
        long avgRecSize = (long)Math.ceil(1.0 * (double)bytesWritten / (double)recordsWritten);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{Long.valueOf(bytesWritten), Long.valueOf(recordsWritten), Long.valueOf(avgRecSize)});
        HashMap<String, Function<Object, String>> fieldNameToConverterMap = new HashMap<String, Function<Object, String>>();
        fieldNameToConverterMap.put("Total Bytes Written", entry -> NumericUtils.humanReadableByteCount((double)Long.parseLong(entry.toString())));
        TableHeader header = new TableHeader().addTableHeaderField("Total Bytes Written for entire commit").addTableHeaderField("Total Records Written for entire commit").addTableHeaderField("Avg record size for entire commit");
        return HoodiePrintHelper.print(header, fieldNameToConverterMap, sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @CliCommand(value={"commit showfiles"}, help="Show file level details of a commit")
    public String showCommitFiles(@CliOption(key={"createView"}, mandatory=false, help="view name to store output table", unspecifiedDefaultValue="") String exportTableName, @CliOption(key={"commit"}, help="Commit to show") String instantTime, @CliOption(key={"limit"}, help="Limit commits", unspecifiedDefaultValue="-1") Integer limit, @CliOption(key={"sortBy"}, help="Sorting Field", unspecifiedDefaultValue="") String sortByField, @CliOption(key={"desc"}, help="Ordering", unspecifiedDefaultValue="false") boolean descending, @CliOption(key={"headeronly"}, help="Print Header Only", unspecifiedDefaultValue="false") boolean headerOnly) throws Exception {
        HoodieInstant commitInstant;
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        if (!timeline.containsInstant(commitInstant = new HoodieInstant(false, "commit", instantTime))) {
            return "Commit " + instantTime + " not found in Commits " + timeline;
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])activeTimeline.getInstantDetails(commitInstant).get()), HoodieCommitMetadata.class);
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        for (Map.Entry entry : meta.getPartitionToWriteStats().entrySet()) {
            String path = (String)entry.getKey();
            List stats = (List)entry.getValue();
            for (HoodieWriteStat stat : stats) {
                rows.add(new Comparable[]{path, stat.getFileId(), stat.getPrevCommit(), Long.valueOf(stat.getNumUpdateWrites()), Long.valueOf(stat.getNumWrites()), Long.valueOf(stat.getTotalWriteBytes()), Long.valueOf(stat.getTotalWriteErrors()), Long.valueOf(stat.getFileSizeInBytes())});
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("Partition Path").addTableHeaderField("FileId").addTableHeaderField("Previous Commit").addTableHeaderField("Total Records Updated").addTableHeaderField("Total Records Written").addTableHeaderField("Total Bytes Written").addTableHeaderField("Total Errors").addTableHeaderField("File Size");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows, exportTableName);
    }

    @CliCommand(value={"commits compare"}, help="Compare commits with another Hoodie table")
    public String compareCommits(@CliOption(key={"path"}, help="Path of the table to compare to") String path) {
        String sourceLatestCommit;
        HoodieTableMetaClient source = HoodieCLI.getTableMetaClient();
        HoodieTableMetaClient target = HoodieTableMetaClient.builder().setConf(HoodieCLI.conf).setBasePath(path).build();
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)targetTimeline.lastInstant().get()).getTimestamp() : "0";
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? ((HoodieInstant)sourceTimeline.lastInstant().get()).getTimestamp() : "0";
        if (sourceLatestCommit != null && HoodieTimeline.compareTimestamps((String)targetLatestCommit, (BiPredicate)HoodieTimeline.GREATER_THAN, (String)sourceLatestCommit)) {
            List commitsToCatchup = targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
            return "Source " + source.getTableConfig().getTableName() + " is behind by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
        }
        List commitsToCatchup = sourceTimeline.findInstantsAfter(targetLatestCommit, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        return "Source " + source.getTableConfig().getTableName() + " is ahead by " + commitsToCatchup.size() + " commits. Commits to catch up - " + commitsToCatchup;
    }

    @CliCommand(value={"commits sync"}, help="Compare commits with another Hoodie table")
    public String syncCommits(@CliOption(key={"path"}, help="Path of the table to compare to") String path) {
        HoodieCLI.syncTableMetadata = HoodieTableMetaClient.builder().setConf(HoodieCLI.conf).setBasePath(path).build();
        HoodieCLI.state = HoodieCLI.CLIState.SYNC;
        return "Load sync state between " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " and " + HoodieCLI.syncTableMetadata.getTableConfig().getTableName();
    }
}

