/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.collection.JavaConverters;
import scala.collection.Map;

@ShellComponent
public class ClusteringCommand {
    @ShellMethod(key={"clustering schedule"}, value="Schedule Clustering")
    public String scheduleClustering(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="1g", help="Spark executor memory") String sparkMemory, @ShellOption(value={"--propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for clustering", defaultValue="") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", defaultValue="") String[] configs) throws Exception {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        String clusteringInstantTime = client.createNewInstantTime();
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.CLUSTERING_SCHEDULE.toString(), master, sparkMemory, client.getBasePath(), client.getTableConfig().getTableName(), clusteringInstantTime, propsFilePath});
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to schedule clustering for " + clusteringInstantTime;
        }
        return "Succeeded to schedule clustering for " + clusteringInstantTime;
    }

    @ShellMethod(key={"clustering run"}, value="Run Clustering")
    public String runClustering(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master, @ShellOption(value={"--sparkMemory"}, help="Spark executor memory", defaultValue="4g") String sparkMemory, @ShellOption(value={"--parallelism"}, help="Parallelism for hoodie clustering", defaultValue="1") String parallelism, @ShellOption(value={"--retry"}, help="Number of retries", defaultValue="1") String retry, @ShellOption(value={"--clusteringInstant"}, help="Clustering instant time", defaultValue="__NULL__") String clusteringInstantTime, @ShellOption(value={"--propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for compacting", defaultValue="") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", defaultValue="") String[] configs) throws Exception {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.CLUSTERING_RUN.toString(), master, sparkMemory, client.getBasePath(), client.getTableConfig().getTableName(), clusteringInstantTime, parallelism, retry, propsFilePath});
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to run clustering for " + clusteringInstantTime;
        }
        return "Succeeded to run clustering for " + clusteringInstantTime;
    }

    @ShellMethod(key={"clustering scheduleAndExecute"}, value="Run Clustering. Make a cluster plan first and execute that plan immediately")
    public String runClustering(@ShellOption(value={"--sparkMaster"}, defaultValue="yarn", help="Spark master") String master, @ShellOption(value={"--sparkMemory"}, help="Spark executor memory", defaultValue="4g") String sparkMemory, @ShellOption(value={"--parallelism"}, help="Parallelism for hoodie clustering", defaultValue="1") String parallelism, @ShellOption(value={"--retry"}, help="Number of retries", defaultValue="1") String retry, @ShellOption(value={"--propsFilePath"}, help="path to properties file on localfs or dfs with configurations for hoodie client for compacting", defaultValue="") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, help="Any configuration that can be set in the properties file can be passed here in the form of an array", defaultValue="") String[] configs) throws Exception {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)((Map)JavaConverters.mapAsScalaMapConverter(System.getenv()).asScala()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        sparkLauncher.addAppArgs(new String[]{SparkMain.SparkCommand.CLUSTERING_SCHEDULE_AND_EXECUTE.toString(), master, sparkMemory, client.getBasePath(), client.getTableConfig().getTableName(), parallelism, retry, propsFilePath});
        UtilHelpers.validateAndAddProperties((String[])configs, (SparkLauncher)sparkLauncher);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to run clustering for scheduleAndExecute.";
        }
        return "Succeeded to run clustering for scheduleAndExecute";
    }
}

