/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.collection.Map;

@ShellComponent
public class ArchivedCommitsCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ArchivedCommitsCommand.class);

    @ShellMethod(key={"trigger archival"}, value="trigger archival")
    public String triggerArchival(@ShellOption(value={"--minCommits"}, help="Minimum number of instants to retain in the active timeline. See hoodie.keep.min.commits", defaultValue="20") int minCommits, @ShellOption(value={"--maxCommits"}, help="Maximum number of instants to retain in the active timeline. See hoodie.keep.max.commits", defaultValue="30") int maxCommits, @ShellOption(value={"--commitsRetainedByCleaner"}, help="Number of commits to retain, without cleaning", defaultValue="10") int retained, @ShellOption(value={"--enableMetadata"}, help="Enable the internal metadata table which serves table metadata like level file listings", defaultValue="true") boolean enableMetadata, @ShellOption(value={"--sparkMemory"}, defaultValue="1G", help="Spark executor memory") String sparkMemory, @ShellOption(value={"--sparkMaster"}, defaultValue="local", help="Spark Master") String master) throws Exception {
        String sparkPropertiesPath = Utils.getDefaultPropertiesFile((Map)JavaScalaConverters.convertJavaPropertiesToScalaMap((Properties)System.getProperties()));
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.ARCHIVE, master, sparkMemory, Integer.toString(minCommits), Integer.toString(maxCommits), Integer.toString(retained), Boolean.toString(enableMetadata), HoodieCLI.basePath);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            return "Failed to trigger archival";
        }
        return "Archival successfully triggered";
    }

    @ShellMethod(key={"show archived commit stats"}, value="Read commits from archived files and show file group details")
    public String showArchivedCommits(@ShellOption(value={"--archiveFolderPattern"}, help="Archive Folder", defaultValue="") String folder, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws IOException {
        System.out.println("===============> Showing only " + limit + " archived commits <===============");
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        StoragePath archivePath = folder != null && !folder.isEmpty() ? new StoragePath(metaClient.getMetaPath(), folder) : new StoragePath(metaClient.getArchivePath(), ".commits_.archive*");
        HoodieStorage storage = metaClient.getStorage();
        List pathInfoList = storage.globEntries(archivePath);
        ArrayList<Comparable[]> allStats = new ArrayList<Comparable[]>();
        for (StoragePathInfo pathInfo : pathInfoList) {
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)storage, (HoodieLogFile)new HoodieLogFile(pathInfo.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            Throwable throwable = null;
            try {
                ArrayList readRecords = new ArrayList();
                while (reader.hasNext()) {
                    HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                    blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO).forEachRemaining(r -> readRecords.add((IndexedRecord)r.getData()));
                }
                List readCommits = readRecords.stream().map(r -> (GenericRecord)r).filter(r -> r.get("actionType").toString().equals("commit") || r.get("actionType").toString().equals("deltacommit")).flatMap(r -> {
                    HoodieCommitMetadata metadata = (HoodieCommitMetadata)SpecificData.get().deepCopy(HoodieCommitMetadata.SCHEMA$, r.get("hoodieCommitMetadata"));
                    String instantTime = r.get("commitTime").toString();
                    String action = r.get("actionType").toString();
                    return metadata.getPartitionToWriteStats().values().stream().flatMap(hoodieWriteStats -> hoodieWriteStats.stream().map(hoodieWriteStat -> {
                        ArrayList<Object> row = new ArrayList<Object>();
                        row.add(action);
                        row.add(instantTime);
                        row.add(hoodieWriteStat.getPartitionPath());
                        row.add(hoodieWriteStat.getFileId());
                        row.add(hoodieWriteStat.getPrevCommit());
                        row.add(hoodieWriteStat.getNumWrites());
                        row.add(hoodieWriteStat.getNumInserts());
                        row.add(hoodieWriteStat.getNumDeletes());
                        row.add(hoodieWriteStat.getNumUpdateWrites());
                        row.add(hoodieWriteStat.getTotalLogFiles());
                        row.add(hoodieWriteStat.getTotalLogBlocks());
                        row.add(hoodieWriteStat.getTotalCorruptLogBlock());
                        row.add(hoodieWriteStat.getTotalRollbackBlocks());
                        row.add(hoodieWriteStat.getTotalLogRecords());
                        row.add(hoodieWriteStat.getTotalUpdatedRecordsCompacted());
                        row.add(hoodieWriteStat.getTotalWriteBytes());
                        row.add(hoodieWriteStat.getTotalWriteErrors());
                        return row;
                    })).map(rowList -> rowList.toArray(new Comparable[0]));
                }).collect(Collectors.toList());
                allStats.addAll(readCommits);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("action").addTableHeaderField("instant").addTableHeaderField("partition").addTableHeaderField("file_id").addTableHeaderField("prev_instant").addTableHeaderField("num_writes").addTableHeaderField("num_inserts").addTableHeaderField("num_deletes").addTableHeaderField("num_update_writes").addTableHeaderField("total_log_files").addTableHeaderField("total_log_blocks").addTableHeaderField("total_corrupt_log_blocks").addTableHeaderField("total_rollback_blocks").addTableHeaderField("total_log_records").addTableHeaderField("total_updated_records_compacted").addTableHeaderField("total_write_bytes").addTableHeaderField("total_write_errors");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, allStats);
    }

    @ShellMethod(key={"show archived commits"}, value="Read commits from archived files and show details")
    public String showCommits(@ShellOption(value={"--skipMetadata"}, help="Skip displaying commit metadata", defaultValue="true") boolean skipMetadata, @ShellOption(value={"--limit"}, help="Limit commits", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws IOException {
        System.out.println("===============> Showing only " + limit + " archived commits <===============");
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        StoragePath basePath = metaClient.getBasePath();
        StoragePath archivePath = new StoragePath(metaClient.getArchivePath(), ".commits_.archive*");
        List pathInfoList = HoodieStorageUtils.getStorage((StoragePath)basePath, HoodieCLI.conf).globEntries(archivePath);
        ArrayList<Comparable[]> allCommits = new ArrayList<Comparable[]>();
        for (StoragePathInfo pathInfo : pathInfoList) {
            HoodieLogFormat.Reader reader = HoodieLogFormat.newReader((HoodieStorage)HoodieStorageUtils.getStorage((StoragePath)basePath, HoodieCLI.conf), (HoodieLogFile)new HoodieLogFile(pathInfo.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
            Throwable throwable = null;
            try {
                ArrayList readRecords = new ArrayList();
                while (reader.hasNext()) {
                    HoodieAvroDataBlock blk = (HoodieAvroDataBlock)reader.next();
                    ClosableIterator recordItr = blk.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                    Throwable throwable2 = null;
                    try {
                        recordItr.forEachRemaining(r -> readRecords.add(r.getData()));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (recordItr == null) continue;
                        if (throwable2 != null) {
                            try {
                                recordItr.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        recordItr.close();
                    }
                }
                List readCommits = readRecords.stream().map(r -> (GenericRecord)r).map(r -> this.readCommit((GenericRecord)r, skipMetadata)).collect(Collectors.toList());
                allCommits.addAll(readCommits);
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                reader.close();
            }
        }
        TableHeader header = new TableHeader().addTableHeaderField("CommitTime").addTableHeaderField("CommitType");
        if (!skipMetadata) {
            header = header.addTableHeaderField("CommitDetails");
        }
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, allCommits);
    }

    private Comparable[] commitDetail(GenericRecord record, String metadataName, boolean skipMetadata) {
        ArrayList<Object> commitDetails = new ArrayList<Object>();
        commitDetails.add(record.get("commitTime"));
        commitDetails.add(record.get("actionType").toString());
        if (!skipMetadata) {
            commitDetails.add(Option.ofNullable((Object)record.get(metadataName)).orElse((Object)"{}").toString());
        }
        return commitDetails.toArray(new Comparable[commitDetails.size()]);
    }

    private Comparable[] readCommit(GenericRecord record, boolean skipMetadata) {
        String actionType;
        switch (actionType = record.get("actionType").toString()) {
            case "clean": {
                return this.commitDetail(record, "hoodieCleanMetadata", skipMetadata);
            }
            case "commit": 
            case "deltacommit": {
                return this.commitDetail(record, "hoodieCommitMetadata", skipMetadata);
            }
            case "rollback": {
                return this.commitDetail(record, "hoodieRollbackMetadata", skipMetadata);
            }
            case "savepoint": {
                return this.commitDetail(record, "hoodieSavePointMetadata", skipMetadata);
            }
            case "compaction": {
                return this.commitDetail(record, "hoodieCompactionMetadata", skipMetadata);
            }
            case "replacecommit": 
            case "clustering": {
                return this.commitDetail(record, "hoodieReplaceCommitMetadata", skipMetadata);
            }
        }
        throw new HoodieException("Unexpected action type: " + actionType);
    }
}

