/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class MarkersCommand {
    @ShellMethod(key={"marker delete"}, value="Delete the marker")
    public String deleteMarker(@ShellOption(value={"--commit"}, help="Delete a marker") String instantTime, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="1G", help="Spark executor memory") String sparkMemory) throws Exception {
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.DELETE_MARKER, master, sparkMemory, instantTime, HoodieCLI.basePath);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not delete marker \"%s\".", instantTime);
        }
        return String.format("Marker \"%s\" deleted.", instantTime);
    }
}

