/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class RestoresCommand {
    @ShellMethod(key={"show restores"}, value="List all restore instants")
    public String showRestores(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly, @ShellOption(value={"--includeInflights"}, help="Also list restores that are in flight", defaultValue="false") boolean includeInflights) {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        List<HoodieInstant> restoreInstants = this.getRestoreInstants(activeTimeline, includeInflights);
        ArrayList<Comparable[]> outputRows = new ArrayList<Comparable[]>();
        for (HoodieInstant restoreInstant : restoreInstants) {
            this.populateOutputFromRestoreInstant(restoreInstant, outputRows, activeTimeline);
        }
        TableHeader header = this.createResultHeader();
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, outputRows);
    }

    @ShellMethod(key={"show restore"}, value="Show details of a restore instant")
    public String showRestore(@ShellOption(value={"--instant"}, help="Restore instant") String restoreInstant, @ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        List matchingInstants = activeTimeline.filterCompletedInstants().filter(completed -> completed.requestedTime().equals(restoreInstant)).getInstants();
        if (matchingInstants.isEmpty()) {
            matchingInstants = activeTimeline.filterInflights().filter(inflight -> inflight.requestedTime().equals(restoreInstant)).getInstants();
        }
        HoodieInstant instant = (HoodieInstant)matchingInstants.get(0);
        ArrayList<Comparable[]> outputRows = new ArrayList<Comparable[]>();
        this.populateOutputFromRestoreInstant(instant, outputRows, activeTimeline);
        TableHeader header = this.createResultHeader();
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, outputRows);
    }

    private void addDetailsOfCompletedRestore(HoodieActiveTimeline activeTimeline, List<Comparable[]> rows, HoodieInstant restoreInstant) throws IOException {
        Option instantDetails = activeTimeline.getInstantDetails(restoreInstant);
        HoodieRestoreMetadata instantMetadata = (HoodieRestoreMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])instantDetails.get()), HoodieRestoreMetadata.class);
        for (String rolledbackInstant : instantMetadata.getInstantsToRollback()) {
            Comparable[] row = this.createDataRow((Comparable)((Object)instantMetadata.getStartRestoreTime()), (Comparable)((Object)rolledbackInstant), Long.valueOf(instantMetadata.getTimeTakenInMillis()), (Comparable)restoreInstant.getState());
            rows.add(row);
        }
    }

    private void addDetailsOfInflightRestore(HoodieActiveTimeline activeTimeline, List<Comparable[]> rows, HoodieInstant restoreInstant) throws IOException {
        HoodieRestorePlan restorePlan = this.getRestorePlan(activeTimeline, restoreInstant);
        for (HoodieInstantInfo instantToRollback : restorePlan.getInstantsToRollback()) {
            Comparable[] dataRow = this.createDataRow((Comparable)((Object)restoreInstant.requestedTime()), (Comparable)((Object)instantToRollback.getCommitTime()), (Comparable)((Object)""), (Comparable)restoreInstant.getState());
            rows.add(dataRow);
        }
    }

    private HoodieRestorePlan getRestorePlan(HoodieActiveTimeline activeTimeline, HoodieInstant restoreInstant) throws IOException {
        HoodieInstant instantKey = HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, "restore", restoreInstant.requestedTime());
        Option instantDetails = activeTimeline.getInstantDetails(instantKey);
        HoodieRestorePlan restorePlan = (HoodieRestorePlan)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])instantDetails.get()), HoodieRestorePlan.class);
        return restorePlan;
    }

    private List<HoodieInstant> getRestoreInstants(HoodieActiveTimeline activeTimeline, boolean includeInFlight) {
        ArrayList<HoodieInstant> restores = new ArrayList<HoodieInstant>();
        restores.addAll(activeTimeline.getRestoreTimeline().filterCompletedInstants().getInstants());
        if (includeInFlight) {
            restores.addAll(activeTimeline.getRestoreTimeline().filterInflights().getInstants());
        }
        return restores;
    }

    private TableHeader createResultHeader() {
        return new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Restored Instant").addTableHeaderField("Time taken in millis").addTableHeaderField("Restore State");
    }

    private void populateOutputFromRestoreInstant(HoodieInstant restoreInstant, List<Comparable[]> outputRows, HoodieActiveTimeline activeTimeline) {
        try {
            if (restoreInstant.isInflight() || restoreInstant.isRequested()) {
                this.addDetailsOfInflightRestore(activeTimeline, outputRows, restoreInstant);
            } else if (restoreInstant.isCompleted()) {
                this.addDetailsOfCompletedRestore(activeTimeline, outputRows, restoreInstant);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Comparable[] createDataRow(Comparable restoreInstantTimestamp, Comparable rolledbackInstantTimestamp, Comparable timeInterval, Comparable state) {
        Comparable[] row = new Comparable[]{restoreInstantTimestamp, rolledbackInstantTimestamp, timeInterval, state};
        return row;
    }
}

