/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class RollbacksCommand {
    @ShellMethod(key={"show rollbacks"}, value="List all rollback instants")
    public String showRollbacks(@ShellOption(value={"--limit"}, help="Limit #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline rollback = activeTimeline.getRollbackTimeline().filterCompletedInstants();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rollback.getInstants().forEach(instant -> {
            try {
                HoodieRollbackMetadata metadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])activeTimeline.getInstantDetails(instant).get()), HoodieRollbackMetadata.class);
                metadata.getCommitsRollback().forEach(c -> {
                    Comparable[] row = new Comparable[]{metadata.getStartRollbackTime(), c, Integer.valueOf(metadata.getTotalFilesDeleted()), Long.valueOf(metadata.getTimeTakenInMillis()), Integer.valueOf(metadata.getPartitionMetadata() != null ? metadata.getPartitionMetadata().size() : 0)};
                    rows.add(row);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Rolledback Instant").addTableHeaderField("Total Files Deleted").addTableHeaderField("Time taken in millis").addTableHeaderField("Total Partitions");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @ShellMethod(key={"show rollback"}, value="Show details of a rollback instant")
    public String showRollback(@ShellOption(value={"--instant"}, help="Rollback instant") String rollbackInstant, @ShellOption(value={"--limit"}, help="Limit  #rows to be displayed", defaultValue="10") Integer limit, @ShellOption(value={"--sortBy"}, help="Sorting Field", defaultValue="") String sortByField, @ShellOption(value={"--desc"}, help="Ordering", defaultValue="false") boolean descending, @ShellOption(value={"--headeronly"}, help="Print Header Only", defaultValue="false") boolean headerOnly) throws IOException {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        HoodieRollbackMetadata metadata = (HoodieRollbackMetadata)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])activeTimeline.getInstantDetails(HoodieCLI.getTableMetaClient().createNewInstant(HoodieInstant.State.COMPLETED, "rollback", rollbackInstant)).get()), HoodieRollbackMetadata.class);
        metadata.getPartitionMetadata().forEach((key, value) -> Stream.concat(value.getSuccessDeleteFiles().stream().map(f -> Pair.of((Object)f, (Object)true)), value.getFailedDeleteFiles().stream().map(f -> Pair.of((Object)f, (Object)false))).forEach(fileWithDeleteStatus -> {
            Comparable[] row = new Comparable[]{metadata.getStartRollbackTime(), metadata.getCommitsRollback().toString(), key, (Comparable)fileWithDeleteStatus.getLeft(), (Comparable)fileWithDeleteStatus.getRight()};
            rows.add(row);
        }));
        TableHeader header = new TableHeader().addTableHeaderField("Instant").addTableHeaderField("Rolledback Instant").addTableHeaderField("Partition").addTableHeaderField("Deleted File").addTableHeaderField("Succeeded");
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), sortByField, descending, limit, headerOnly, rows);
    }

    @ShellMethod(key={"commit rollback"}, value="Rollback a commit")
    public String rollbackCommit(@ShellOption(value={"--commit"}, help="Commit to rollback") String instantTime, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory, @ShellOption(value={"--rollbackUsingMarkers"}, defaultValue="false", help="Enabling marker based rollback") String rollbackUsingMarkers) throws Exception {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline filteredTimeline = activeTimeline.filter(instant -> instant.requestedTime().equals(instantTime));
        if (filteredTimeline.empty()) {
            return "Commit " + instantTime + " not found in Commits " + activeTimeline;
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.ROLLBACK, master, sparkMemory, instantTime, HoodieCLI.basePath, rollbackUsingMarkers);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return "Commit " + instantTime + " failed to roll back";
        }
        return "Commit " + instantTime + " rolled back";
    }
}

