/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.commands.SparkMain;
import org.apache.hudi.cli.utils.InputStreamConsumer;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.launcher.SparkLauncher;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class SavepointsCommand {
    @ShellMethod(key={"savepoints show"}, value="Show the savepoints")
    public String showSavepoints() {
        HoodieActiveTimeline activeTimeline = HoodieCLI.getTableMetaClient().getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getSavePointTimeline().filterCompletedInstants();
        List commits = timeline.getReverseOrderedInstants().collect(Collectors.toList());
        String[][] rows = new String[commits.size()][];
        for (int i = 0; i < commits.size(); ++i) {
            HoodieInstant commit = (HoodieInstant)commits.get(i);
            rows[i] = new String[]{commit.requestedTime()};
        }
        return HoodiePrintHelper.print(new String[]{"SavepointTime"}, rows);
    }

    @ShellMethod(key={"savepoint create"}, value="Savepoint a commit")
    public String savepoint(@ShellOption(value={"--commit"}, help="Commit to savepoint") String commitTime, @ShellOption(value={"--user"}, defaultValue="default", help="User who is creating the savepoint") String user, @ShellOption(value={"--comments"}, defaultValue="default", help="Comments for creating the savepoint") String comments, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (!activeTimeline.getCommitsTimeline().filterCompletedInstants().containsInstant(commitTime)) {
            return String.format("Commit %s not found in Commits %s", commitTime, activeTimeline);
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.SAVEPOINT, master, sparkMemory, commitTime, user, comments, HoodieCLI.basePath);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not create savepoint \"%s\".", commitTime);
        }
        return String.format("The commit \"%s\" has been savepointed.", commitTime);
    }

    @ShellMethod(key={"savepoint rollback"}, value="Savepoint a commit")
    public String rollbackToSavepoint(@ShellOption(value={"--savepoint"}, help="Savepoint to rollback") String instantTime, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--lazyFailedWritesCleanPolicy"}, help="True if FailedWriteCleanPolicy is lazy", defaultValue="false") String lazyFailedWritesCleanPolicy, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        if (metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants().empty()) {
            throw new HoodieException("There are no completed instants to run rollback");
        }
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        List instants = timeline.getInstantsAsStream().filter(instant -> instant.requestedTime().equals(instantTime)).collect(Collectors.toList());
        if (instants.isEmpty()) {
            return String.format("Commit %s not found in Commits %s", instantTime, timeline);
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.ROLLBACK_TO_SAVEPOINT, master, sparkMemory, instantTime, HoodieCLI.basePath, lazyFailedWritesCleanPolicy);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Savepoint \"%s\" failed to roll back", instantTime);
        }
        return String.format("Savepoint \"%s\" rolled back", instantTime);
    }

    @ShellMethod(key={"savepoint delete"}, value="Delete the savepoint")
    public String deleteSavepoint(@ShellOption(value={"--commit"}, help="Delete a savepoint") String instantTime, @ShellOption(value={"--sparkProperties"}, help="Spark Properties File Path", defaultValue="") String sparkPropertiesPath, @ShellOption(value={"--sparkMaster"}, defaultValue="", help="Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Spark executor memory") String sparkMemory) throws Exception {
        HoodieTableMetaClient metaClient = HoodieCLI.getTableMetaClient();
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        HoodieInstant savePoint = metaClient.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", instantTime);
        if (!completedInstants.containsInstant(savePoint)) {
            return String.format("Commit %s not found in Commits %s", instantTime, completedInstants);
        }
        SparkLauncher sparkLauncher = SparkUtil.initLauncher(sparkPropertiesPath);
        SparkMain.addAppArgs(sparkLauncher, SparkMain.SparkCommand.DELETE_SAVEPOINT, master, sparkMemory, instantTime, HoodieCLI.basePath);
        Process process = sparkLauncher.launch();
        InputStreamConsumer.captureOutput(process);
        int exitCode = process.waitFor();
        HoodieCLI.refreshTableMetadata();
        if (exitCode != 0) {
            return String.format("Failed: Could not delete savepoint \"%s\".", instantTime);
        }
        return String.format("Savepoint \"%s\" deleted.", instantTime);
    }
}

