/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.cli.ArchiveExecutorUtils;
import org.apache.hudi.cli.utils.SparkUtil;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.utilities.HDFSParquetImporter;
import org.apache.hudi.utilities.HoodieCleaner;
import org.apache.hudi.utilities.HoodieClusteringJob;
import org.apache.hudi.utilities.HoodieCompactionAdminTool;
import org.apache.hudi.utilities.HoodieCompactor;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.streamer.BootstrapExecutor;
import org.apache.hudi.utilities.streamer.HoodieStreamer;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.launcher.SparkLauncher;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.hudi.DeDupeType;
import org.apache.spark.sql.hudi.DedupeSparkJob;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkMain {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMain.class);

    public static void addAppArgs(SparkLauncher sparkLauncher, SparkCommand cmd, String ... args) {
        ValidationUtils.checkArgument((args.length == cmd.minArgsCount - 1 ? 1 : 0) != 0, (String)"For developers only: App args does not match minArgsCount");
        sparkLauncher.addAppArgs(new String[]{cmd.toString()});
        sparkLauncher.addAppArgs(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        ValidationUtils.checkArgument((boolean)(args.length >= 4));
        commandString = args[0];
        SparkMain.LOG.info("Invoking SparkMain: {}", (Object)commandString);
        cmd = SparkCommand.valueOf(commandString);
        jsc = SparkUtil.initJavaSparkContext("hoodie-cli-" + commandString, (Option<String>)Option.of((Object)args[1]), (Option<String>)Option.of((Object)args[2]));
        returnCode = 0;
        try {
            cmd.assertGtEq(args.length);
            configs = cmd.makeConfigs(args);
            propsFilePath = cmd.getPropsFilePath(args);
            switch (1.$SwitchMap$org$apache$hudi$cli$commands$SparkMain$SparkCommand[cmd.ordinal()]) {
                case 1: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.rollback(jsc, args[3], args[4], Boolean.parseBoolean(args[5]));
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 2: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.deduplicatePartitionPath(jsc, args[3], args[4], args[5], Boolean.parseBoolean(args[6]), args[7]);
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 3: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.rollbackToSavepoint(jsc, args[3], args[4], Boolean.parseBoolean(args[5]));
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 4: 
                case 5: {
                    returnCode = SparkMain.dataLoad(jsc, commandString, args[3], args[4], args[5], args[6], args[7], args[8], Integer.parseInt(args[9]), args[10], Integer.parseInt(args[11]), propsFilePath, configs);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 6: {
                    returnCode = SparkMain.compact(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), args[7], Integer.parseInt(args[8]), "execute", propsFilePath, configs);
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 7: {
                    returnCode = SparkMain.compact(jsc, args[3], args[4], null, Integer.parseInt(args[5]), args[6], Integer.parseInt(args[7]), "scheduleandexecute", propsFilePath, configs);
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 8: {
                    returnCode = SparkMain.compact(jsc, args[3], args[4], args[5], 1, "", 0, "schedule", propsFilePath, configs);
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                case 9: {
                    cmd.assertEq(args.length);
                    SparkMain.doCompactValidate(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]));
                    returnCode = 0;
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                case 10: {
                    cmd.assertEq(args.length);
                    SparkMain.doCompactRepair(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), Boolean.parseBoolean(args[7]));
                    returnCode = 0;
                    ** break;
lbl54:
                    // 1 sources

                    break;
                }
                case 11: {
                    cmd.assertEq(args.length);
                    SparkMain.doCompactUnscheduleFile(jsc, args[3], args[4], args[5], args[6], Integer.parseInt(args[7]), Boolean.parseBoolean(args[8]), Boolean.parseBoolean(args[9]));
                    returnCode = 0;
                    ** break;
lbl60:
                    // 1 sources

                    break;
                }
                case 12: {
                    cmd.assertEq(args.length);
                    SparkMain.doCompactUnschedule(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), Boolean.parseBoolean(args[7]), Boolean.parseBoolean(args[8]));
                    returnCode = 0;
                    ** break;
lbl66:
                    // 1 sources

                    break;
                }
                case 13: {
                    returnCode = SparkMain.cluster(jsc, args[3], args[4], args[5], Integer.parseInt(args[6]), args[2], Integer.parseInt(args[7]), "execute", propsFilePath, configs);
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 14: {
                    returnCode = SparkMain.cluster(jsc, args[3], args[4], null, Integer.parseInt(args[5]), args[2], Integer.parseInt(args[6]), "scheduleandexecute", propsFilePath, configs);
                    ** break;
lbl74:
                    // 1 sources

                    break;
                }
                case 15: {
                    returnCode = SparkMain.cluster(jsc, args[3], args[4], args[5], 1, args[2], 0, "schedule", propsFilePath, configs);
                    ** break;
lbl78:
                    // 1 sources

                    break;
                }
                case 16: {
                    SparkMain.clean(jsc, args[3], propsFilePath, configs);
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 17: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.createSavepoint(jsc, args[3], args[4], args[5], args[6]);
                    ** break;
lbl87:
                    // 1 sources

                    break;
                }
                case 18: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.deleteMarker(jsc, args[3], args[4]);
                    ** break;
lbl92:
                    // 1 sources

                    break;
                }
                case 19: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.deleteSavepoint(jsc, args[3], args[4]);
                    ** break;
lbl97:
                    // 1 sources

                    break;
                }
                case 20: {
                    returnCode = SparkMain.doBootstrap(jsc, args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17], args[18], args[19], propsFilePath, configs);
                    ** break;
lbl101:
                    // 1 sources

                    break;
                }
                case 21: 
                case 22: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.upgradeOrDowngradeTable(jsc, args[3], args[4]);
                    ** break;
lbl106:
                    // 1 sources

                    break;
                }
                case 23: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.repairDeprecatedPartition(jsc, args[3]);
                    ** break;
lbl111:
                    // 1 sources

                    break;
                }
                case 24: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.renamePartition(jsc, args[3], args[4], args[5]);
                    ** break;
lbl116:
                    // 1 sources

                    break;
                }
                case 25: {
                    cmd.assertEq(args.length);
                    returnCode = SparkMain.archive(jsc, Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), Boolean.parseBoolean(args[6]), args[7]);
                    ** break;
lbl121:
                    // 1 sources

                    break;
                }
                ** default:
lbl123:
                // 1 sources

                break;
            }
        }
        catch (Exception exception) {
            SparkMain.LOG.error("Fail to execute commandString", (Throwable)exception);
            returnCode = -1;
        }
        finally {
            jsc.stop();
        }
        System.exit(returnCode);
    }

    protected static void clean(JavaSparkContext jsc, String basePath, String propsFilePath, List<String> configs) {
        HoodieCleaner.Config cfg = new HoodieCleaner.Config();
        cfg.basePath = basePath;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        new HoodieCleaner(cfg, jsc).run();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int deleteMarker(JavaSparkContext jsc, String instantTime, String basePath) {
        try (SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath, false);){
            HoodieWriteConfig config = client.getConfig();
            HoodieEngineContext context = client.getEngineContext();
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)context);
            client.validateAgainstTableProperties(table.getMetaClient().getTableConfig(), config);
            WriteMarkersFactory.get((MarkerType)config.getMarkersType(), (HoodieTable)table, (String)instantTime).quietDeleteMarkerDir(context, config.getMarkersDeleteParallelism());
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed: Could not clean marker instantTime: \"%s\".", instantTime), (Throwable)e);
            return -1;
        }
    }

    private static int dataLoad(JavaSparkContext jsc, String command, String srcPath, String targetPath, String tableName, String tableType, String rowKey, String partitionKey, int parallelism, String schemaFile, int retry, String propsFilePath, List<String> configs) {
        HDFSParquetImporter.Config cfg = new HDFSParquetImporter.Config();
        cfg.command = command;
        cfg.srcPath = srcPath;
        cfg.targetPath = targetPath;
        cfg.tableName = tableName;
        cfg.tableType = tableType;
        cfg.rowKey = rowKey;
        cfg.partitionKey = partitionKey;
        cfg.parallelism = parallelism;
        cfg.schemaFile = schemaFile;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        return new HDFSParquetImporter(cfg).dataImport(jsc, retry);
    }

    private static void doCompactValidate(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.VALIDATE;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactRepair(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.REPAIR;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactUnschedule(JavaSparkContext jsc, String basePath, String compactionInstant, String outputPath, int parallelism, boolean skipValidation, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.UNSCHEDULE_PLAN;
        cfg.outputPath = outputPath;
        cfg.compactionInstantTime = compactionInstant;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        cfg.skipValidation = skipValidation;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static void doCompactUnscheduleFile(JavaSparkContext jsc, String basePath, String fileId, String partitionPath, String outputPath, int parallelism, boolean skipValidation, boolean dryRun) throws Exception {
        HoodieCompactionAdminTool.Config cfg = new HoodieCompactionAdminTool.Config();
        cfg.basePath = basePath;
        cfg.operation = HoodieCompactionAdminTool.Operation.UNSCHEDULE_FILE;
        cfg.outputPath = outputPath;
        cfg.partitionPath = partitionPath;
        cfg.fileId = fileId;
        cfg.parallelism = parallelism;
        cfg.dryRun = dryRun;
        cfg.skipValidation = skipValidation;
        new HoodieCompactionAdminTool(cfg).run(jsc);
    }

    private static int compact(JavaSparkContext jsc, String basePath, String tableName, String compactionInstant, int parallelism, String schemaFile, int retry, String mode, String propsFilePath, List<String> configs) {
        HoodieCompactor.Config cfg = new HoodieCompactor.Config();
        cfg.basePath = basePath;
        cfg.tableName = tableName;
        cfg.compactionInstantTime = compactionInstant;
        cfg.strategyClassName = UnBoundedCompactionStrategy.class.getCanonicalName();
        cfg.parallelism = parallelism;
        cfg.schemaFile = schemaFile;
        cfg.runningMode = mode;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        return new HoodieCompactor(jsc, cfg).compact(retry);
    }

    private static int cluster(JavaSparkContext jsc, String basePath, String tableName, String clusteringInstant, int parallelism, String sparkMemory, int retry, String runningMode, String propsFilePath, List<String> configs) {
        HoodieClusteringJob.Config cfg = new HoodieClusteringJob.Config();
        cfg.basePath = basePath;
        cfg.tableName = tableName;
        cfg.clusteringInstantTime = clusteringInstant;
        cfg.parallelism = parallelism;
        cfg.runningMode = runningMode;
        cfg.propsFilePath = propsFilePath;
        cfg.configs = configs;
        jsc.getConf().set("spark.executor.memory", sparkMemory);
        return new HoodieClusteringJob(jsc, cfg).cluster(retry);
    }

    private static int deduplicatePartitionPath(JavaSparkContext jsc, String duplicatedPartitionPath, String repairedOutputPath, String basePath, boolean dryRun, String dedupeType) {
        DedupeSparkJob job = new DedupeSparkJob(basePath, duplicatedPartitionPath, repairedOutputPath, new SQLContext(jsc), HoodieStorageUtils.getStorage((String)basePath, (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)jsc.hadoopConfiguration())), DeDupeType.withName((String)dedupeType));
        job.fixDuplicates(dryRun);
        return 0;
    }

    public static int repairDeprecatedPartition(JavaSparkContext jsc, String basePath) {
        SQLContext sqlContext = new SQLContext(jsc);
        Dataset<Row> recordsToRewrite = SparkMain.getRecordsToRewrite(basePath, "default", sqlContext);
        if (!recordsToRewrite.isEmpty()) {
            recordsToRewrite.cache();
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)jsc.hadoopConfiguration())).setBasePath(basePath).build();
            Map<String, String> propsMap = SparkMain.getPropsForRewrite(metaClient);
            SparkMain.rewriteRecordsToNewPartition(basePath, "__HIVE_DEFAULT_PARTITION__", recordsToRewrite, metaClient, propsMap);
            SparkMain.deleteOlderPartition(basePath, "default", recordsToRewrite, propsMap);
        }
        return 0;
    }

    public static int renamePartition(JavaSparkContext jsc, String basePath, String oldPartition, String newPartition) {
        SQLContext sqlContext = new SQLContext(jsc);
        Dataset<Row> recordsToRewrite = SparkMain.getRecordsToRewrite(basePath, oldPartition, sqlContext);
        if (!recordsToRewrite.isEmpty()) {
            recordsToRewrite.cache();
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)jsc.hadoopConfiguration())).setBasePath(basePath).build();
            Map<String, String> propsMap = SparkMain.getPropsForRewrite(metaClient);
            SparkMain.rewriteRecordsToNewPartition(basePath, newPartition, recordsToRewrite, metaClient, propsMap);
            SparkMain.deleteOlderPartition(basePath, oldPartition, recordsToRewrite, propsMap);
            FileSystem fs = HadoopFSUtils.getFs((Path)new Path(basePath), (StorageConfiguration)metaClient.getStorageConf());
            try {
                fs.delete(new Path(basePath, oldPartition), true);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete older partition {}", (Object)basePath);
            }
        }
        return 0;
    }

    private static void deleteOlderPartition(String basePath, String oldPartition, Dataset<Row> recordsToRewrite, Map<String, String> propsMap) {
        propsMap.put("hoodie.datasource.write.partitions.to.delete", oldPartition);
        recordsToRewrite.write().options(propsMap).option("hoodie.datasource.write.operation", WriteOperationType.DELETE_PARTITION.value()).format("hudi").mode("Append").save(basePath);
    }

    private static void rewriteRecordsToNewPartition(String basePath, String newPartition, Dataset<Row> recordsToRewrite, HoodieTableMetaClient metaClient, Map<String, String> propsMap) {
        String partitionFieldProp = metaClient.getTableConfig().getPartitionFieldProp();
        StructType structType = recordsToRewrite.schema();
        int partitionIndex = structType.fieldIndex(partitionFieldProp);
        recordsToRewrite.withColumn(metaClient.getTableConfig().getPartitionFieldProp(), functions.lit((Object)newPartition).cast(structType.apply(partitionIndex).dataType())).write().options(propsMap).option("hoodie.datasource.write.operation", WriteOperationType.BULK_INSERT.value()).format("hudi").mode("Append").save(basePath);
    }

    private static Dataset<Row> getRecordsToRewrite(String basePath, String oldPartition, SQLContext sqlContext) {
        return sqlContext.read().format("hudi").load(basePath + "/" + oldPartition).drop(HoodieRecord.RECORD_KEY_METADATA_FIELD).drop(HoodieRecord.PARTITION_PATH_METADATA_FIELD).drop(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD).drop(HoodieRecord.FILENAME_METADATA_FIELD).drop(HoodieRecord.COMMIT_TIME_METADATA_FIELD);
    }

    private static Map<String, String> getPropsForRewrite(HoodieTableMetaClient metaClient) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        metaClient.getTableConfig().getProps().forEach((k, v) -> propsMap.put(k.toString(), v.toString()));
        propsMap.put(HoodieWriteConfig.SKIP_DEFAULT_PARTITION_VALIDATION.key(), "true");
        propsMap.put(DataSourceWriteOptions.RECORDKEY_FIELD().key(), metaClient.getTableConfig().getRecordKeyFieldProp());
        propsMap.put(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), (String)HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)metaClient.getTableConfig()).orElse((Object)""));
        propsMap.put(DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME().key(), metaClient.getTableConfig().getKeyGeneratorClassName());
        return propsMap;
    }

    private static int doBootstrap(JavaSparkContext jsc, String tableName, String tableType, String basePath, String sourcePath, String recordKeyCols, String partitionFields, String parallelism, String schemaProviderClass, String bootstrapIndexClass, String selectorClass, String keyGenerator, String fullBootstrapInputProvider, String recordMergeMode, String payloadClassName, String recordMergeStrategyId, String recordMergeImplClasses, String enableHiveSync, String propsFilePath, List<String> configs) throws IOException {
        TypedProperties properties = propsFilePath == null ? UtilHelpers.buildProperties(configs) : UtilHelpers.readConfig((Configuration)jsc.hadoopConfiguration(), (Path)new Path(propsFilePath), configs).getProps(true);
        properties.setProperty(HoodieBootstrapConfig.BASE_PATH.key(), sourcePath);
        if (!StringUtils.isNullOrEmpty((String)keyGenerator) && KeyGeneratorType.getNames().contains(keyGenerator.toUpperCase(Locale.ROOT))) {
            properties.setProperty(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), keyGenerator.toUpperCase(Locale.ROOT));
        } else {
            properties.setProperty(DataSourceWriteOptions.KEYGENERATOR_CLASS_NAME().key(), keyGenerator);
        }
        properties.setProperty(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME.key(), fullBootstrapInputProvider);
        properties.setProperty(HoodieBootstrapConfig.PARALLELISM_VALUE.key(), parallelism);
        properties.setProperty(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME.key(), selectorClass);
        properties.setProperty(DataSourceWriteOptions.RECORDKEY_FIELD().key(), recordKeyCols);
        properties.setProperty(DataSourceWriteOptions.PARTITIONPATH_FIELD().key(), partitionFields);
        HoodieStreamer.Config cfg = new HoodieStreamer.Config();
        cfg.targetTableName = tableName;
        cfg.targetBasePath = basePath;
        cfg.tableType = tableType;
        cfg.schemaProviderClassName = schemaProviderClass;
        cfg.bootstrapIndexClass = bootstrapIndexClass;
        cfg.payloadClassName = payloadClassName;
        cfg.recordMergeMode = RecordMergeMode.getValue((String)recordMergeMode);
        cfg.recordMergeStrategyId = recordMergeStrategyId;
        cfg.recordMergeImplClasses = recordMergeImplClasses;
        cfg.enableHiveSync = Boolean.valueOf(enableHiveSync);
        new BootstrapExecutor(cfg, jsc, HadoopFSUtils.getFs((String)basePath, (Configuration)jsc.hadoopConfiguration()), jsc.hadoopConfiguration(), properties).execute();
        return 0;
    }

    private static int rollback(JavaSparkContext jsc, String instantTime, String basePath, Boolean rollbackUsingMarkers) throws Exception {
        SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath, rollbackUsingMarkers, false);
        if (client.rollback(instantTime)) {
            LOG.info("The commit \"{}\" rolled back.", (Object)instantTime);
            return 0;
        }
        LOG.warn("The commit \"{}\" failed to roll back.", (Object)instantTime);
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int createSavepoint(JavaSparkContext jsc, String commitTime, String user, String comments, String basePath) throws Exception {
        try (SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath, false);){
            client.savepoint(commitTime, user, comments);
            LOG.info("The commit \"{}\" has been savepointed.", (Object)commitTime);
            int n = 0;
            return n;
        }
        catch (HoodieSavepointException se) {
            LOG.warn("Failed: Could not create savepoint \"{}\".", (Object)commitTime);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int rollbackToSavepoint(JavaSparkContext jsc, String savepointTime, String basePath, boolean lazyCleanPolicy) throws Exception {
        try (SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath, lazyCleanPolicy);){
            client.restoreToSavepoint(savepointTime);
            LOG.info("The commit \"{}\" rolled back.", (Object)savepointTime);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.warn(String.format("The commit \"%s\" failed to roll back.", savepointTime), (Throwable)e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int deleteSavepoint(JavaSparkContext jsc, String savepointTime, String basePath) throws Exception {
        try (SparkRDDWriteClient client = SparkMain.createHoodieClient(jsc, basePath, false);){
            client.deleteSavepoint(savepointTime);
            LOG.info("Savepoint \"{}\" deleted.", (Object)savepointTime);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed: Could not delete savepoint \"%s\".", savepointTime), (Throwable)e);
            return -1;
        }
    }

    protected static int upgradeOrDowngradeTable(JavaSparkContext jsc, String basePath, String toVersion) {
        HoodieWriteConfig config = SparkMain.getWriteConfig(basePath, Boolean.parseBoolean((String)HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE.defaultValue()), false);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)jsc.hadoopConfiguration())).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(false).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).build();
        HoodieWriteConfig updatedConfig = HoodieWriteConfig.newBuilder().withProps((Map)config.getProps()).forTable(metaClient.getTableConfig().getTableName()).build();
        try {
            new UpgradeDowngrade(metaClient, updatedConfig, (HoodieEngineContext)new HoodieSparkEngineContext(jsc), (SupportsUpgradeDowngrade)SparkUpgradeDowngradeHelper.getInstance()).run(HoodieTableVersion.valueOf((String)toVersion), null);
            LOG.info("Table at \"{}\" upgraded / downgraded to version \"{}\".", (Object)basePath, (Object)toVersion);
            return 0;
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed: Could not upgrade/downgrade table at \"%s\" to version \"%s\".", basePath, toVersion), (Throwable)e);
            return -1;
        }
    }

    private static SparkRDDWriteClient createHoodieClient(JavaSparkContext jsc, String basePath, Boolean rollbackUsingMarkers, boolean lazyCleanPolicy) throws Exception {
        HoodieWriteConfig config = SparkMain.getWriteConfig(basePath, rollbackUsingMarkers, lazyCleanPolicy);
        return new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(jsc), config);
    }

    private static SparkRDDWriteClient createHoodieClient(JavaSparkContext jsc, String basePath, boolean lazyCleanPolicy) throws Exception {
        return SparkMain.createHoodieClient(jsc, basePath, Boolean.parseBoolean((String)HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE.defaultValue()), lazyCleanPolicy);
    }

    private static HoodieWriteConfig getWriteConfig(String basePath, Boolean rollbackUsingMarkers, boolean lazyCleanPolicy) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withRollbackUsingMarkers(rollbackUsingMarkers.booleanValue()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(lazyCleanPolicy ? HoodieFailedWritesCleaningPolicy.LAZY : HoodieFailedWritesCleaningPolicy.EAGER).build()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).build();
    }

    private static int archive(JavaSparkContext jsc, int minCommits, int maxCommits, int commitsRetained, boolean enableMetadata, String basePath) {
        try {
            return ArchiveExecutorUtils.archive((JavaSparkContext)jsc, (int)minCommits, (int)maxCommits, (int)commitsRetained, (boolean)enableMetadata, (String)basePath);
        }
        catch (IOException ex) {
            return -1;
        }
    }

    static enum SparkCommand {
        BOOTSTRAP(21),
        ROLLBACK(6),
        DEDUPLICATE(8),
        ROLLBACK_TO_SAVEPOINT(6),
        SAVEPOINT(7),
        IMPORT(13),
        UPSERT(13),
        COMPACT_SCHEDULE(7),
        COMPACT_RUN(10),
        COMPACT_SCHEDULE_AND_EXECUTE(9),
        COMPACT_UNSCHEDULE_PLAN(9),
        COMPACT_UNSCHEDULE_FILE(10),
        COMPACT_VALIDATE(7),
        COMPACT_REPAIR(8),
        CLUSTERING_SCHEDULE(7),
        CLUSTERING_RUN(9),
        CLUSTERING_SCHEDULE_AND_EXECUTE(8),
        CLEAN(5),
        DELETE_MARKER(5),
        DELETE_SAVEPOINT(5),
        UPGRADE(5),
        DOWNGRADE(5),
        REPAIR_DEPRECATED_PARTITION(4),
        RENAME_PARTITION(6),
        ARCHIVE(8);

        private final int minArgsCount;

        private SparkCommand(int minArgsCount) {
            this.minArgsCount = minArgsCount;
        }

        void assertEq(int factArgsCount) {
            ValidationUtils.checkArgument((factArgsCount == this.minArgsCount ? 1 : 0) != 0);
        }

        void assertGtEq(int factArgsCount) {
            ValidationUtils.checkArgument((factArgsCount >= this.minArgsCount ? 1 : 0) != 0);
        }

        List<String> makeConfigs(String[] args) {
            ArrayList<String> configs = new ArrayList<String>();
            if (args.length > this.minArgsCount) {
                configs.addAll(Arrays.asList(args).subList(this.minArgsCount, args.length));
            }
            return configs;
        }

        String getPropsFilePath(String[] args) {
            return args.length >= this.minArgsCount && !StringUtils.isNullOrEmpty((String)args[this.minArgsCount - 1]) ? args[this.minArgsCount - 1] : null;
        }
    }
}

