/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.cli.HoodieCLI;
import org.apache.hudi.cli.HoodiePrintHelper;
import org.apache.hudi.cli.TableHeader;
import org.apache.hudi.cli.commands.CompactionCommand;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimeGeneratorType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;

@ShellComponent
public class TableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(TableCommand.class);

    @ShellMethod(key={"connect"}, value="Connect to a hoodie table")
    public String connect(@ShellOption(value={"--path"}, help="Base Path of the table") String path, @ShellOption(value={"--eventuallyConsistent"}, defaultValue="false", help="Enable eventual consistency") boolean eventuallyConsistent, @ShellOption(value={"--initialCheckIntervalMs"}, defaultValue="2000", help="Initial wait time for eventual consistency") Integer initialConsistencyIntervalMs, @ShellOption(value={"--maxWaitIntervalMs"}, defaultValue="300000", help="Max wait time for eventual consistency") Integer maxConsistencyIntervalMs, @ShellOption(value={"--maxCheckIntervalMs"}, defaultValue="7", help="Max checks for eventual consistency") Integer maxConsistencyChecks, @ShellOption(value={"--timeGeneratorType"}, defaultValue="WAIT_TO_ADJUST_SKEW", help="Time generator type, which is used to generate globally monotonically increasing timestamp") String timeGeneratorType, @ShellOption(value={"--maxExpectedClockSkewMs"}, defaultValue="200", help="The max expected clock skew time for WaitBasedTimeGenerator in ms") Long maxExpectedClockSkewMs, @ShellOption(value={"--useDefaultLockProvider"}, defaultValue="false", help="Use org.apache.hudi.client.transaction.lock.InProcessLockProvider") boolean useDefaultLockProvider) throws IOException {
        HoodieCLI.setConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(eventuallyConsistent).withInitialConsistencyCheckIntervalMs(initialConsistencyIntervalMs.intValue()).withMaxConsistencyCheckIntervalMs(maxConsistencyIntervalMs.intValue()).withMaxConsistencyChecks(maxConsistencyChecks.intValue()).build());
        HoodieCLI.setTimeGeneratorConfig(HoodieTimeGeneratorConfig.newBuilder().withPath(path).withTimeGeneratorType(TimeGeneratorType.valueOf((String)timeGeneratorType)).withMaxExpectedClockSkewMs(maxExpectedClockSkewMs.longValue()).withDefaultLockProvider(useDefaultLockProvider).build());
        HoodieCLI.initConf();
        HoodieCLI.connectTo(path);
        HoodieCLI.initFS(true);
        HoodieCLI.state = HoodieCLI.CLIState.TABLE;
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " loaded";
    }

    public String createTable(String path, String name, String tableTypeStr, String archiveFolder, String payloadClass) throws IOException {
        return this.createTable(path, name, tableTypeStr, archiveFolder, HoodieTableVersion.current().versionCode(), payloadClass);
    }

    @ShellMethod(key={"create"}, value="Create a hoodie table if not present")
    public String createTable(@ShellOption(value={"--path"}, help="Base Path of the table") String path, @ShellOption(value={"--tableName"}, help="Hoodie Table Name") String name, @ShellOption(value={"--tableType"}, defaultValue="COPY_ON_WRITE", help="Hoodie Table Type. Must be one of : COPY_ON_WRITE or MERGE_ON_READ") String tableTypeStr, @ShellOption(value={"--archiveLogFolder"}, help="Folder Name for storing archived timeline", defaultValue="__NULL__") String archiveFolder, @ShellOption(value={"--tableVersion"}, help="Specific table Version to create table as", defaultValue="__NULL__") Integer tableVersion, @ShellOption(value={"--payloadClass"}, defaultValue="org.apache.hudi.common.model.HoodieAvroPayload", help="Payload Class") String payloadClass) throws IOException {
        boolean initialized = HoodieCLI.initConf();
        HoodieCLI.initFS(initialized);
        boolean existing = false;
        try {
            HoodieTableMetaClient.builder().setConf(HoodieCLI.conf.newInstance()).setBasePath(path).build();
            existing = true;
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        if (existing) {
            throw new IllegalStateException("Table already existing in path : " + path);
        }
        HoodieTableMetaClient.newTableBuilder().setTableType(tableTypeStr).setTableName(name).setArchiveLogFolder(archiveFolder).setPayloadClassName(payloadClass).setTableVersion(tableVersion == null ? HoodieTableVersion.current().versionCode() : tableVersion.intValue()).initTable(HoodieCLI.conf.newInstance(), path);
        return this.connect(path, false, 0, 0, 0, "WAIT_TO_ADJUST_SKEW", 200L, true);
    }

    @ShellMethod(key={"desc"}, value="Describe Hoodie Table properties")
    public String descTable() {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        TableHeader header = new TableHeader().addTableHeaderField("Property").addTableHeaderField("Value");
        ArrayList<Comparable[]> rows = new ArrayList<Comparable[]>();
        rows.add(new Comparable[]{"basePath", client.getBasePath()});
        rows.add(new Comparable[]{"metaPath", client.getMetaPath()});
        rows.add(new Comparable[]{"fileSystem", client.getStorage().getScheme()});
        client.getTableConfig().propsMap().entrySet().forEach(e -> rows.add(new Comparable[]{(Comparable)e.getKey(), (Comparable)e.getValue()}));
        return HoodiePrintHelper.print(header, new HashMap<String, Function<Object, String>>(), "", false, -1, false, rows);
    }

    @ShellMethod(key={"refresh", "metadata refresh", "commits refresh", "cleans refresh", "savepoints refresh"}, value="Refresh table metadata")
    public String refreshMetadata() {
        HoodieCLI.refreshTableMetadata();
        return "Metadata for table " + HoodieCLI.getTableMetaClient().getTableConfig().getTableName() + " refreshed.";
    }

    @ShellMethod(key={"fetch table schema"}, value="Fetches latest table schema")
    public String fetchTableSchema(@ShellOption(value={"--outputFilePath"}, defaultValue="__NULL__", help="File path to write schema") String outputFilePath) throws Exception {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(client);
        Schema schema = tableSchemaResolver.getTableAvroSchema();
        if (outputFilePath != null) {
            LOG.info("Latest table schema : " + schema.toString(true));
            TableCommand.writeToFile(outputFilePath, schema.toString(true));
            return String.format("Latest table schema written to %s", outputFilePath);
        }
        return String.format("Latest table schema %s", schema.toString(true));
    }

    @ShellMethod(key={"table recover-configs"}, value="Recover table configs, from update/delete that failed midway.")
    public String recoverTableConfig() throws IOException {
        HoodieCLI.refreshTableMetadata();
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        HoodieTableConfig.recover((HoodieStorage)client.getStorage(), (StoragePath)client.getMetaPath());
        return this.descTable();
    }

    @ShellMethod(key={"table update-configs"}, value="Update the table configs with configs with provided file.")
    public String updateTableConfig(@ShellOption(value={"--props-file"}, help="Path to a properties file on local filesystem") String updatePropsFilePath) throws IOException {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Map oldProps = client.getTableConfig().propsMap();
        Properties updatedProps = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(updatePropsFilePath);){
            updatedProps.load(fileInputStream);
        }
        HoodieTableConfig.update((HoodieStorage)client.getStorage(), (StoragePath)client.getMetaPath(), (Properties)updatedProps);
        HoodieCLI.refreshTableMetadata();
        Map newProps = HoodieCLI.getTableMetaClient().getTableConfig().propsMap();
        return TableCommand.renderOldNewProps(newProps, oldProps);
    }

    @ShellMethod(key={"table delete-configs"}, value="Delete the supplied table configs from the table.")
    public String deleteTableConfig(@ShellOption(value={"--comma-separated-configs"}, help="Comma separated list of configs to delete.") String csConfigs) {
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        Map oldProps = client.getTableConfig().propsMap();
        Set deleteConfigs = Arrays.stream(csConfigs.split(",")).collect(Collectors.toSet());
        HoodieTableConfig.delete((HoodieStorage)client.getStorage(), (StoragePath)client.getMetaPath(), deleteConfigs);
        HoodieCLI.refreshTableMetadata();
        Map newProps = HoodieCLI.getTableMetaClient().getTableConfig().propsMap();
        return TableCommand.renderOldNewProps(newProps, oldProps);
    }

    @ShellMethod(key={"table change-table-type"}, value="Change hudi table type to target type: COW or MOR. Note: before changing to COW, by default this command will execute all the pending compactions and execute a full compaction if needed.")
    public String changeTableType(@ShellOption(value={"--target-type"}, help="the target hoodie table type: COW or MOR") String changeType, @ShellOption(value={"--enable-compaction"}, defaultValue="true", help="Valid in MOR to COW case. Before changing to COW, need to perform a full compaction to compact all log files. Default true") boolean enableCompaction, @ShellOption(value={"--parallelism"}, defaultValue="3", help="Valid in MOR to COW case. Parallelism for hoodie compaction") String parallelism, @ShellOption(value={"--sparkMaster"}, defaultValue="local", help="Valid in MOR to COW case. Spark Master") String master, @ShellOption(value={"--sparkMemory"}, defaultValue="4G", help="Valid in MOR to COW case. Spark executor memory") String sparkMemory, @ShellOption(value={"--retry"}, defaultValue="1", help="Valid in MOR to COW case. Number of retries") String retry, @ShellOption(value={"--propsFilePath"}, defaultValue="", help="Valid in MOR to COW case. path to properties file on localfs or dfs with configurations for hoodie client for compacting") String propsFilePath, @ShellOption(value={"--hoodieConfigs"}, defaultValue="", help="Valid in MOR to COW case. Any configuration that can be set in the properties file can be passed here in the form of an array") String[] configs) throws Exception {
        String targetType;
        HoodieTableMetaClient client = HoodieCLI.getTableMetaClient();
        String tableName = client.getTableConfig().getTableName();
        StoragePath tablePath = client.getBasePath();
        Map oldProps = client.getTableConfig().propsMap();
        HoodieTableType currentType = client.getTableType();
        switch (changeType) {
            case "MOR": {
                if (currentType.equals((Object)HoodieTableType.MERGE_ON_READ)) {
                    return String.format("table %s path %s is already %s", tableName, tablePath, HoodieTableType.MERGE_ON_READ);
                }
                targetType = HoodieTableType.MERGE_ON_READ.name();
                break;
            }
            case "COW": {
                if (currentType.equals((Object)HoodieTableType.COPY_ON_WRITE)) {
                    return String.format("table %s path %s is already %s", tableName, tablePath, HoodieTableType.COPY_ON_WRITE);
                }
                targetType = HoodieTableType.COPY_ON_WRITE.name();
                if (!enableCompaction) {
                    HoodieActiveTimeline activeTimeline = client.getActiveTimeline();
                    int compactionCount = activeTimeline.filter(instant -> instant.getAction().equals("compaction")).countInstants();
                    if (compactionCount > 0) {
                        String errMsg = String.format("Remain %s compactions to compact, please set --enable-compaction=true", compactionCount);
                        LOG.error(errMsg);
                        throw new HoodieException(errMsg);
                    }
                    Option lastInstant = client.getActiveTimeline().lastInstant();
                    if (!lastInstant.isPresent() || ((HoodieInstant)lastInstant.get()).getAction().equals("commit") && ((HoodieInstant)lastInstant.get()).isCompleted()) break;
                    String errMsg = String.format("The last action must be a completed compaction(commit[COMPLETED]) for this operation. But is %s[status=%s]", ((HoodieInstant)lastInstant.get()).getAction(), ((HoodieInstant)lastInstant.get()).getState());
                    LOG.error(errMsg);
                    throw new HoodieException(errMsg);
                }
                List pendingCompactionInstants = client.getActiveTimeline().filterPendingCompactionTimeline().getInstants();
                LOG.info("Remain {} compaction instants to compact", (Object)pendingCompactionInstants.size());
                for (int i = 0; i < pendingCompactionInstants.size(); ++i) {
                    HoodieInstant compactionInstant = (HoodieInstant)pendingCompactionInstants.get(i);
                    LOG.info("compact {} instant {}", (Object)(i + 1), (Object)compactionInstant);
                    String result = new CompactionCommand().compact(parallelism, "", master, sparkMemory, retry, compactionInstant.requestedTime(), propsFilePath, configs);
                    LOG.info("compact instant {} result: {}", (Object)compactionInstant, (Object)result);
                    if (result.startsWith("Compaction successfully completed for ")) continue;
                    throw new HoodieException(String.format("Compact %s failed", compactionInstant));
                }
                client.reloadActiveTimeline();
                Option lastInstant = client.getActiveTimeline().lastInstant();
                if (!lastInstant.isPresent() || ((HoodieInstant)lastInstant.get()).getAction().equals("commit") && ((HoodieInstant)lastInstant.get()).isCompleted()) break;
                LOG.info("There are remaining logfiles, will perform a full compaction");
                boolean compactionStrategyExist = false;
                boolean compactionNumDeltaExist = false;
                ArrayList<String> newConfigs = new ArrayList<String>();
                for (int i = 0; i < configs.length; ++i) {
                    if (configs[i].startsWith(HoodieCompactionConfig.COMPACTION_STRATEGY.key())) {
                        compactionStrategyExist = true;
                        configs[i] = String.format("%s=%s", HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName());
                    }
                    if (configs[i].startsWith(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key())) {
                        compactionNumDeltaExist = true;
                        configs[i] = String.format("%s=%s", HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1");
                    }
                    newConfigs.add(configs[i]);
                }
                if (!compactionStrategyExist) {
                    newConfigs.add(String.format("%s=%s", HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName()));
                }
                if (!compactionNumDeltaExist) {
                    newConfigs.add(String.format("%s=%s", HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1"));
                }
                String result = new CompactionCommand().compact(parallelism, "", master, sparkMemory, retry, propsFilePath, newConfigs.toArray(new String[0]));
                LOG.info("Full compaction result: {}", (Object)result);
                if (result.equals("Schedule and execute compaction successfully completed")) break;
                throw new HoodieException("Change table type to COW: schedule and execute the full compaction failed");
            }
            default: {
                throw new HoodieException("Unsupported change type " + changeType + ". Only support MOR or COW.");
            }
        }
        Properties updatedProps = new Properties();
        updatedProps.putAll((Map<?, ?>)oldProps);
        updatedProps.put(HoodieTableConfig.TYPE.key(), targetType);
        HoodieTableConfig.update((HoodieStorage)client.getStorage(), (StoragePath)client.getMetaPath(), (Properties)updatedProps);
        HoodieCLI.refreshTableMetadata();
        Map newProps = HoodieCLI.getTableMetaClient().getTableConfig().propsMap();
        return TableCommand.renderOldNewProps(newProps, oldProps);
    }

    private static String renderOldNewProps(Map<String, String> newProps, Map<String, String> oldProps) {
        TreeSet<String> allPropKeys = new TreeSet<String>();
        allPropKeys.addAll(newProps.keySet().stream().map(Object::toString).collect(Collectors.toSet()));
        allPropKeys.addAll(oldProps.keySet());
        String[][] rows = new String[allPropKeys.size()][];
        int ind = 0;
        for (String propKey : allPropKeys) {
            String[] row = new String[]{propKey, oldProps.getOrDefault(propKey, "null"), newProps.getOrDefault(propKey, "null")};
            rows[ind++] = row;
        }
        return HoodiePrintHelper.print(new String[]{"Property", "Old Value", "New Value"}, rows);
    }

    private static void writeToFile(String filePath, String data) throws IOException {
        File outFile = new File(filePath);
        if (outFile.exists()) {
            outFile.delete();
        }
        try (FileOutputStream os = new FileOutputStream(outFile);){
            ((OutputStream)os).write(StringUtils.getUTF8Bytes((String)data), 0, data.length());
        }
    }

    static {
        System.out.println("Table command getting loaded");
    }
}

