/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli.utils;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;

public class CommitUtil {
    public static long countNewRecords(HoodieTableMetaClient metaClient, List<String> commitsToCatchup) throws IOException {
        long totalNew = 0L;
        HoodieTimeline timeline = metaClient.reloadActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants();
        for (String commit : commitsToCatchup) {
            HoodieInstant instant = metaClient.createNewInstant(HoodieInstant.State.COMPLETED, "commit", commit);
            HoodieCommitMetadata c = (HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])timeline.getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            totalNew += c.fetchTotalRecordsWritten() - c.fetchTotalUpdateRecordsWritten();
        }
        return totalNew;
    }

    public static String getTimeDaysAgo(int numberOfDays) {
        Date date = Date.from(ZonedDateTime.now().minusDays(numberOfDays).toInstant());
        return TimelineUtils.formatDate((Date)date);
    }
}

