/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Storage Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control aspects around writing, sizing, reading base and log files.")
@Immutable
public class HoodieStorageConfig
extends HoodieConfig {
    public static final ConfigProperty<String> PARQUET_MAX_FILE_SIZE = ConfigProperty.key((String)"hoodie.parquet.max.file.size").defaultValue((Object)String.valueOf(0x7800000)).withDocumentation("Target size for parquet files produced by Hudi write phases. For DFS, this needs to be aligned with the underlying filesystem block size for optimal performance.");
    public static final ConfigProperty<String> PARQUET_BLOCK_SIZE = ConfigProperty.key((String)"hoodie.parquet.block.size").defaultValue((Object)String.valueOf(0x7800000)).withDocumentation("Parquet RowGroup size. It's recommended to make this large enough that scan costs can be amortized by packing enough column values into a single row group.");
    public static final ConfigProperty<String> PARQUET_PAGE_SIZE = ConfigProperty.key((String)"hoodie.parquet.page.size").defaultValue((Object)String.valueOf(0x100000)).withDocumentation("Parquet page size. Page is the unit of read within a parquet file. Within a block, pages are compressed separately.");
    public static final ConfigProperty<String> ORC_FILE_MAX_SIZE = ConfigProperty.key((String)"hoodie.orc.max.file.size").defaultValue((Object)String.valueOf(0x7800000)).withDocumentation("Target file size for ORC base files.");
    public static final ConfigProperty<String> ORC_STRIPE_SIZE = ConfigProperty.key((String)"hoodie.orc.stripe.size").defaultValue((Object)String.valueOf(0x4000000)).withDocumentation("Size of the memory buffer in bytes for writing");
    public static final ConfigProperty<String> ORC_BLOCK_SIZE = ConfigProperty.key((String)"hoodie.orc.block.size").defaultValue(ORC_FILE_MAX_SIZE.defaultValue()).withDocumentation("ORC block size, recommended to be aligned with the target file size.");
    public static final ConfigProperty<String> HFILE_MAX_FILE_SIZE = ConfigProperty.key((String)"hoodie.hfile.max.file.size").defaultValue((Object)String.valueOf(0x7800000)).withDocumentation("Target file size for HFile base files.");
    public static final ConfigProperty<String> HFILE_BLOCK_SIZE = ConfigProperty.key((String)"hoodie.hfile.block.size").defaultValue((Object)String.valueOf(0x100000)).withDocumentation("Lower values increase the size of metadata tracked within HFile, but can offer potentially faster lookup times.");
    public static final ConfigProperty<String> LOGFILE_MAX_SIZE = ConfigProperty.key((String)"hoodie.logfile.max.size").defaultValue((Object)String.valueOf(0x40000000)).withDocumentation("LogFile max size. This is the maximum size allowed for a log file before it is rolled over to the next version.");
    public static final ConfigProperty<String> LOGFILE_DATA_BLOCK_MAX_SIZE = ConfigProperty.key((String)"hoodie.logfile.data.block.max.size").defaultValue((Object)String.valueOf(0x10000000)).withDocumentation("LogFile Data block max size. This is the maximum size allowed for a single data block to be appended to a log file. This helps to make sure the data appended to the log file is broken up into sizable blocks to prevent from OOM errors. This size should be greater than the JVM memory.");
    public static final ConfigProperty<String> PARQUET_COMPRESSION_RATIO_FRACTION = ConfigProperty.key((String)"hoodie.parquet.compression.ratio").defaultValue((Object)String.valueOf(0.1)).withDocumentation("Expected compression of parquet data used by Hudi, when it tries to size new parquet files. Increase this value, if bulk_insert is producing smaller than expected sized files");
    public static final ConfigProperty<String> PARQUET_COMPRESSION_CODEC_NAME = ConfigProperty.key((String)"hoodie.parquet.compression.codec").defaultValue((Object)"gzip").withDocumentation("Compression Codec for parquet files");
    public static final ConfigProperty<Boolean> PARQUET_DICTIONARY_ENABLED = ConfigProperty.key((String)"hoodie.parquet.dictionary.enabled").defaultValue((Object)true).withDocumentation("Whether to use dictionary encoding");
    public static final ConfigProperty<String> PARQUET_WRITE_LEGACY_FORMAT_ENABLED = ConfigProperty.key((String)"hoodie.parquet.writelegacyformat.enabled").defaultValue((Object)"false").withDocumentation("Sets spark.sql.parquet.writeLegacyFormat. If true, data will be written in a way of Spark 1.4 and earlier. For example, decimal values will be written in Parquet's fixed-length byte array format which other systems such as Apache Hive and Apache Impala use. If false, the newer format in Parquet will be used. For example, decimals will be written in int-based format.");
    public static final ConfigProperty<String> PARQUET_OUTPUT_TIMESTAMP_TYPE = ConfigProperty.key((String)"hoodie.parquet.outputtimestamptype").defaultValue((Object)"TIMESTAMP_MILLIS").withDocumentation("Sets spark.sql.parquet.outputTimestampType. Parquet timestamp type to use when Spark writes data to Parquet files.");
    public static final ConfigProperty<String> HFILE_COMPRESSION_ALGORITHM_NAME = ConfigProperty.key((String)"hoodie.hfile.compression.algorithm").defaultValue((Object)"GZ").withDocumentation("Compression codec to use for hfile base files.");
    public static final ConfigProperty<String> ORC_COMPRESSION_CODEC_NAME = ConfigProperty.key((String)"hoodie.orc.compression.codec").defaultValue((Object)"ZLIB").withDocumentation("Compression codec to use for ORC base files.");
    public static final ConfigProperty<String> LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION = ConfigProperty.key((String)"hoodie.logfile.to.parquet.compression.ratio").defaultValue((Object)String.valueOf(0.35)).withDocumentation("Expected additional compression as records move from log files to parquet. Used for merge_on_read table to send inserts into log files & control the size of compacted parquet file.");
    @Deprecated
    public static final String PARQUET_FILE_MAX_BYTES = PARQUET_MAX_FILE_SIZE.key();
    @Deprecated
    public static final String DEFAULT_PARQUET_FILE_MAX_BYTES = (String)PARQUET_MAX_FILE_SIZE.defaultValue();
    @Deprecated
    public static final String PARQUET_BLOCK_SIZE_BYTES = PARQUET_BLOCK_SIZE.key();
    @Deprecated
    public static final String DEFAULT_PARQUET_BLOCK_SIZE_BYTES = (String)PARQUET_BLOCK_SIZE.defaultValue();
    @Deprecated
    public static final String PARQUET_PAGE_SIZE_BYTES = PARQUET_PAGE_SIZE.key();
    @Deprecated
    public static final String DEFAULT_PARQUET_PAGE_SIZE_BYTES = (String)PARQUET_PAGE_SIZE.defaultValue();
    @Deprecated
    public static final String HFILE_FILE_MAX_BYTES = HFILE_MAX_FILE_SIZE.key();
    @Deprecated
    public static final String DEFAULT_HFILE_FILE_MAX_BYTES = (String)HFILE_MAX_FILE_SIZE.defaultValue();
    @Deprecated
    public static final String HFILE_BLOCK_SIZE_BYTES = (String)HFILE_BLOCK_SIZE.defaultValue();
    @Deprecated
    public static final String DEFAULT_HFILE_BLOCK_SIZE_BYTES = (String)HFILE_BLOCK_SIZE.defaultValue();
    @Deprecated
    public static final String LOGFILE_SIZE_MAX_BYTES = LOGFILE_MAX_SIZE.key();
    @Deprecated
    public static final String DEFAULT_LOGFILE_SIZE_MAX_BYTES = (String)LOGFILE_MAX_SIZE.defaultValue();
    @Deprecated
    public static final String LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES = LOGFILE_DATA_BLOCK_MAX_SIZE.key();
    @Deprecated
    public static final String DEFAULT_LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES = (String)LOGFILE_DATA_BLOCK_MAX_SIZE.defaultValue();
    @Deprecated
    public static final String PARQUET_COMPRESSION_RATIO = PARQUET_COMPRESSION_RATIO_FRACTION.key();
    @Deprecated
    public static final String DEFAULT_STREAM_COMPRESSION_RATIO = (String)PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue();
    @Deprecated
    public static final String PARQUET_COMPRESSION_CODEC = PARQUET_COMPRESSION_CODEC_NAME.key();
    @Deprecated
    public static final String HFILE_COMPRESSION_ALGORITHM = HFILE_COMPRESSION_ALGORITHM_NAME.key();
    @Deprecated
    public static final String DEFAULT_PARQUET_COMPRESSION_CODEC = (String)PARQUET_COMPRESSION_CODEC_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_HFILE_COMPRESSION_ALGORITHM = (String)HFILE_COMPRESSION_ALGORITHM_NAME.defaultValue();
    @Deprecated
    public static final String LOGFILE_TO_PARQUET_COMPRESSION_RATIO = LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION.key();
    @Deprecated
    public static final String DEFAULT_LOGFILE_TO_PARQUET_COMPRESSION_RATIO = (String)LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue();

    private HoodieStorageConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieStorageConfig storageConfig = new HoodieStorageConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.storageConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.storageConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder parquetMaxFileSize(long maxFileSize) {
            this.storageConfig.setValue(PARQUET_MAX_FILE_SIZE, String.valueOf(maxFileSize));
            return this;
        }

        public Builder parquetBlockSize(int blockSize) {
            this.storageConfig.setValue(PARQUET_BLOCK_SIZE, String.valueOf(blockSize));
            return this;
        }

        public Builder parquetPageSize(int pageSize) {
            this.storageConfig.setValue(PARQUET_PAGE_SIZE, String.valueOf(pageSize));
            return this;
        }

        public Builder hfileMaxFileSize(long maxFileSize) {
            this.storageConfig.setValue(HFILE_MAX_FILE_SIZE, String.valueOf(maxFileSize));
            return this;
        }

        public Builder hfileBlockSize(int blockSize) {
            this.storageConfig.setValue(HFILE_BLOCK_SIZE, String.valueOf(blockSize));
            return this;
        }

        public Builder logFileDataBlockMaxSize(int dataBlockSize) {
            this.storageConfig.setValue(LOGFILE_DATA_BLOCK_MAX_SIZE, String.valueOf(dataBlockSize));
            return this;
        }

        public Builder logFileMaxSize(long logFileSize) {
            this.storageConfig.setValue(LOGFILE_MAX_SIZE, String.valueOf(logFileSize));
            return this;
        }

        public Builder parquetCompressionRatio(double parquetCompressionRatio) {
            this.storageConfig.setValue(PARQUET_COMPRESSION_RATIO_FRACTION, String.valueOf(parquetCompressionRatio));
            return this;
        }

        public Builder parquetCompressionCodec(String parquetCompressionCodec) {
            this.storageConfig.setValue(PARQUET_COMPRESSION_CODEC_NAME, parquetCompressionCodec);
            return this;
        }

        public Builder parquetWriteLegacyFormat(String parquetWriteLegacyFormat) {
            this.storageConfig.setValue(PARQUET_WRITE_LEGACY_FORMAT_ENABLED, parquetWriteLegacyFormat);
            return this;
        }

        public Builder parquetOutputTimestampType(String parquetOutputTimestampType) {
            this.storageConfig.setValue(PARQUET_OUTPUT_TIMESTAMP_TYPE, parquetOutputTimestampType);
            return this;
        }

        public Builder hfileCompressionAlgorithm(String hfileCompressionAlgorithm) {
            this.storageConfig.setValue(HFILE_COMPRESSION_ALGORITHM_NAME, hfileCompressionAlgorithm);
            return this;
        }

        public Builder logFileToParquetCompressionRatio(double logFileToParquetCompressionRatio) {
            this.storageConfig.setValue(LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION, String.valueOf(logFileToParquetCompressionRatio));
            return this;
        }

        public Builder orcMaxFileSize(long maxFileSize) {
            this.storageConfig.setValue(ORC_FILE_MAX_SIZE, String.valueOf(maxFileSize));
            return this;
        }

        public Builder orcStripeSize(int orcStripeSize) {
            this.storageConfig.setValue(ORC_STRIPE_SIZE, String.valueOf(orcStripeSize));
            return this;
        }

        public Builder orcBlockSize(int orcBlockSize) {
            this.storageConfig.setValue(ORC_BLOCK_SIZE, String.valueOf(orcBlockSize));
            return this;
        }

        public Builder orcCompressionCodec(String orcCompressionCodec) {
            this.storageConfig.setValue(ORC_COMPRESSION_CODEC_NAME, orcCompressionCodec);
            return this;
        }

        public HoodieStorageConfig build() {
            this.storageConfig.setDefaults(HoodieStorageConfig.class.getName());
            return this.storageConfig;
        }
    }
}

