/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Hashtable;
import java.util.Map;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.upgrade.BaseUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class TwoToThreeUpgradeHandler
implements UpgradeHandler {
    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, BaseUpgradeDowngradeHelper upgradeDowngradeHelper) {
        if (config.isMetadataTableEnabled()) {
            HoodieTableMetadataUtil.deleteMetadataTable((String)config.getBasePath(), (HoodieEngineContext)context);
        }
        Hashtable<ConfigProperty, String> tablePropsToAdd = new Hashtable<ConfigProperty, String>();
        tablePropsToAdd.put(HoodieTableConfig.URL_ENCODE_PARTITIONING, config.getStringOrDefault(HoodieTableConfig.URL_ENCODE_PARTITIONING));
        tablePropsToAdd.put(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE, config.getStringOrDefault(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE));
        String keyGenClassName = (String)Option.ofNullable((Object)config.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)).orElse((Object)config.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME));
        ValidationUtils.checkState((keyGenClassName != null ? 1 : 0) != 0, (String)String.format("Missing config: %s or %s", HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, HoodieWriteConfig.KEYGENERATOR_CLASS_NAME));
        tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, keyGenClassName);
        return tablePropsToAdd;
    }
}

