/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class InProcessLockProvider
implements LockProvider<ReentrantReadWriteLock>,
Serializable {
    private static final Logger LOG = LogManager.getLogger(InProcessLockProvider.class);
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private final long maxWaitTimeMillis;

    public InProcessLockProvider(LockConfiguration lockConfiguration, Configuration conf) {
        TypedProperties typedProperties = lockConfiguration.getConfig();
        this.maxWaitTimeMillis = typedProperties.getLong("hoodie.write.lock.wait_time_ms", 60000L);
    }

    public void lock() {
        LOG.info((Object)this.getLogMessage(LockState.ACQUIRING));
        if (LOCK.isWriteLockedByCurrentThread()) {
            throw new HoodieLockException(this.getLogMessage(LockState.ALREADY_ACQUIRED));
        }
        LOCK.writeLock().lock();
        LOG.info((Object)this.getLogMessage(LockState.ACQUIRED));
    }

    public boolean tryLock() {
        return this.tryLock(this.maxWaitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public boolean tryLock(long time, @NotNull TimeUnit unit) {
        boolean isLockAcquired;
        LOG.info((Object)this.getLogMessage(LockState.ACQUIRING));
        if (LOCK.isWriteLockedByCurrentThread()) {
            throw new HoodieLockException(this.getLogMessage(LockState.ALREADY_ACQUIRED));
        }
        try {
            isLockAcquired = LOCK.writeLock().tryLock(time, unit);
        }
        catch (InterruptedException e) {
            throw new HoodieLockException(this.getLogMessage(LockState.FAILED_TO_ACQUIRE));
        }
        LOG.info((Object)this.getLogMessage(isLockAcquired ? LockState.ACQUIRED : LockState.FAILED_TO_ACQUIRE));
        return isLockAcquired;
    }

    public void unlock() {
        LOG.info((Object)this.getLogMessage(LockState.RELEASING));
        try {
            if (LOCK.isWriteLockedByCurrentThread()) {
                LOCK.writeLock().unlock();
            } else {
                LOG.warn((Object)"Cannot unlock because the current thread does not hold the lock.");
            }
        }
        catch (Exception e) {
            throw new HoodieLockException(this.getLogMessage(LockState.FAILED_TO_RELEASE), (Throwable)e);
        }
        LOG.info((Object)this.getLogMessage(LockState.RELEASED));
    }

    public ReentrantReadWriteLock getLock() {
        return LOCK;
    }

    public void close() {
        if (LOCK.isWriteLockedByCurrentThread()) {
            LOCK.writeLock().unlock();
        }
    }

    private String getLogMessage(LockState state) {
        return StringUtils.join((String[])new String[]{"Thread ", String.valueOf(Thread.currentThread().getName()), " ", state.name(), " in-process lock."});
    }
}

