/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.HoodieKeyLookupHandle;
import org.apache.hudi.io.HoodieKeyLookupResult;
import org.apache.hudi.table.HoodieTable;

public class HoodieBaseBloomIndexCheckFunction
implements Function<Iterator<Pair<String, HoodieKey>>, Iterator<List<HoodieKeyLookupResult>>> {
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig config;

    public HoodieBaseBloomIndexCheckFunction(HoodieTable hoodieTable, HoodieWriteConfig config) {
        this.hoodieTable = hoodieTable;
        this.config = config;
    }

    @Override
    public Iterator<List<HoodieKeyLookupResult>> apply(Iterator<Pair<String, HoodieKey>> filePartitionRecordKeyTripletItr) {
        return new LazyKeyCheckIterator(filePartitionRecordKeyTripletItr);
    }

    class LazyKeyCheckIterator
    extends LazyIterableIterator<Pair<String, HoodieKey>, List<HoodieKeyLookupResult>> {
        private HoodieKeyLookupHandle keyLookupHandle;

        LazyKeyCheckIterator(Iterator<Pair<String, HoodieKey>> filePartitionRecordKeyTripletItr) {
            super(filePartitionRecordKeyTripletItr);
        }

        @Override
        protected void start() {
        }

        @Override
        protected List<HoodieKeyLookupResult> computeNext() {
            ArrayList<HoodieKeyLookupResult> ret = new ArrayList<HoodieKeyLookupResult>();
            try {
                while (this.inputItr.hasNext()) {
                    Pair currentTuple = (Pair)this.inputItr.next();
                    String fileId = (String)currentTuple.getLeft();
                    String partitionPath = ((HoodieKey)currentTuple.getRight()).getPartitionPath();
                    String recordKey = ((HoodieKey)currentTuple.getRight()).getRecordKey();
                    Pair partitionPathFilePair = Pair.of((Object)partitionPath, (Object)fileId);
                    if (this.keyLookupHandle == null) {
                        this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBaseBloomIndexCheckFunction.this.config, HoodieBaseBloomIndexCheckFunction.this.hoodieTable, (Pair<String, String>)partitionPathFilePair);
                    }
                    if (this.keyLookupHandle.getPartitionPathFileIDPair().equals((Object)partitionPathFilePair)) {
                        this.keyLookupHandle.addKey(recordKey);
                        continue;
                    }
                    ret.add(this.keyLookupHandle.getLookupResult());
                    this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBaseBloomIndexCheckFunction.this.config, HoodieBaseBloomIndexCheckFunction.this.hoodieTable, (Pair<String, String>)partitionPathFilePair);
                    this.keyLookupHandle.addKey(recordKey);
                    break;
                }
                if (!this.inputItr.hasNext()) {
                    ret.add(this.keyLookupHandle.getLookupResult());
                }
            }
            catch (Throwable e) {
                if (e instanceof HoodieException) {
                    throw e;
                }
                throw new HoodieIndexException("Error checking bloom filter index. ", e);
            }
            return ret;
        }

        @Override
        protected void end() {
        }
    }
}

