/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;

public interface HoodieFileWriter<R extends IndexedRecord> {
    public void writeAvroWithMetadata(HoodieKey var1, R var2) throws IOException;

    public boolean canWrite();

    public void close() throws IOException;

    public void writeAvro(String var1, R var2) throws IOException;

    default public void prepRecordWithMetadata(HoodieKey key, R avroRecord, String instantTime, Integer partitionId, long recordIndex, String fileName) {
        String seqId = HoodieRecord.generateSequenceId((String)instantTime, (int)partitionId, (long)recordIndex);
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)((GenericRecord)avroRecord), (String)key.getRecordKey(), (String)key.getPartitionPath(), (String)fileName);
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)((GenericRecord)avroRecord), (String)instantTime, (String)seqId);
    }
}

