/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.MergingIterator;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class BaseMergeHelper<T extends HoodieRecordPayload, I, K, O> {
    public abstract void runMerge(HoodieTable<T, I, K, O> var1, HoodieMergeHandle<T, I, K, O> var2) throws IOException;

    protected GenericRecord transformRecordBasedOnNewSchema(GenericDatumReader<GenericRecord> gReader, GenericDatumWriter<GenericRecord> gWriter, ThreadLocal<BinaryEncoder> encoderCache, ThreadLocal<BinaryDecoder> decoderCache, GenericRecord gRec) {
        ByteArrayOutputStream inStream = null;
        try {
            GenericRecord transformedRec;
            inStream = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)inStream, encoderCache.get());
            encoderCache.set(encoder);
            gWriter.write((Object)gRec, (Encoder)encoder);
            encoder.flush();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(inStream.toByteArray(), decoderCache.get());
            decoderCache.set(decoder);
            GenericRecord genericRecord = transformedRec = (GenericRecord)gReader.read(null, (Decoder)decoder);
            return genericRecord;
        }
        catch (IOException e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                throw new HoodieException(ioe.getMessage(), (Throwable)ioe);
            }
        }
    }

    protected Iterator<GenericRecord> getMergingIterator(HoodieTable<T, I, K, O> table, HoodieMergeHandle<T, I, K, O> mergeHandle, HoodieBaseFile baseFile, HoodieFileReader<GenericRecord> reader, Schema readSchema, boolean externalSchemaTransformation) throws IOException {
        Path externalFilePath = new Path(((BaseFile)baseFile.getBootstrapBaseFile().get()).getPath());
        Configuration bootstrapFileConfig = new Configuration(table.getHadoopConf());
        HoodieFileReader bootstrapReader = HoodieFileReaderFactory.getFileReader((Configuration)bootstrapFileConfig, (Path)externalFilePath);
        Schema bootstrapReadSchema = externalSchemaTransformation ? bootstrapReader.getSchema() : mergeHandle.getWriterSchema();
        return new MergingIterator<GenericRecord>((Iterator<GenericRecord>)reader.getRecordIterator(readSchema), (Iterator<GenericRecord>)bootstrapReader.getRecordIterator(bootstrapReadSchema), (Function<Pair<GenericRecord, GenericRecord>, GenericRecord>)((Function<Pair, GenericRecord>)inputRecordPair -> HoodieAvroUtils.stitchRecords((GenericRecord)((GenericRecord)inputRecordPair.getLeft()), (GenericRecord)((GenericRecord)inputRecordPair.getRight()), (Schema)mergeHandle.getWriterSchemaWithMetaFields())));
    }

    protected static class UpdateHandler
    extends BoundedInMemoryQueueConsumer<GenericRecord, Void> {
        private final HoodieMergeHandle upsertHandle;

        protected UpdateHandler(HoodieMergeHandle upsertHandle) {
            this.upsertHandle = upsertHandle;
        }

        protected void consumeOneRecord(GenericRecord record) {
            this.upsertHandle.write(record);
        }

        protected void finish() {
        }

        protected Void getResult() {
            return null;
        }
    }
}

