/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;

public abstract class BaseActionExecutor<T extends HoodieRecordPayload, I, K, O, R>
implements Serializable {
    protected final transient HoodieEngineContext context;
    protected final transient Configuration hadoopConf;
    protected final HoodieWriteConfig config;
    protected final HoodieTable<T, I, K, O> table;
    protected final String instantTime;

    public BaseActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime) {
        this.context = context;
        this.hadoopConf = context.getHadoopConf().get();
        this.config = config;
        this.table = table;
        this.instantTime = instantTime;
    }

    public abstract R execute();

    protected final void writeTableMetadata(HoodieCommitMetadata metadata, String actionType) {
        this.table.getMetadataWriter(this.instantTime).ifPresent(w -> w.update(metadata, this.instantTime, this.table.isTableServiceAction(actionType)));
    }

    protected final void writeTableMetadata(HoodieCleanMetadata metadata, String instantTime) {
        this.table.getMetadataWriter(instantTime).ifPresent(w -> w.update(metadata, instantTime));
    }

    protected final void writeTableMetadata(HoodieRollbackMetadata metadata) {
        this.table.getMetadataWriter(this.instantTime, Option.of((Object)metadata)).ifPresent(w -> w.update(metadata, this.instantTime));
    }

    protected final void writeTableMetadata(HoodieRestoreMetadata metadata) {
        this.table.getMetadataWriter(this.instantTime, Option.of((Object)metadata)).ifPresent(w -> w.update(metadata, this.instantTime));
    }
}

