/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap.selector;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.bootstrap.selector.BootstrapModeSelector;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BootstrapRegexModeSelector
extends BootstrapModeSelector {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(BootstrapRegexModeSelector.class);
    private final Pattern pattern;
    private final BootstrapMode bootstrapModeOnMatch;
    private final BootstrapMode defaultMode;

    public BootstrapRegexModeSelector(HoodieWriteConfig writeConfig) {
        super(writeConfig);
        this.pattern = Pattern.compile(writeConfig.getBootstrapModeSelectorRegex());
        this.bootstrapModeOnMatch = writeConfig.getBootstrapModeForRegexMatch();
        this.defaultMode = BootstrapMode.FULL_RECORD.equals((Object)this.bootstrapModeOnMatch) ? BootstrapMode.METADATA_ONLY : BootstrapMode.FULL_RECORD;
        LOG.info((Object)("Default Mode :" + (Object)((Object)this.defaultMode) + ", on Match Mode :" + (Object)((Object)this.bootstrapModeOnMatch)));
    }

    @Override
    public Map<BootstrapMode, List<String>> select(List<Pair<String, List<HoodieFileStatus>>> partitions) {
        return partitions.stream().map(p -> Pair.of((Object)((Object)(this.pattern.matcher((CharSequence)p.getKey()).matches() ? this.bootstrapModeOnMatch : this.defaultMode)), (Object)p.getKey())).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toList())));
    }
}

