/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TransactionManager
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(TransactionManager.class);
    private final LockManager lockManager;
    private final boolean isOptimisticConcurrencyControlEnabled;
    private Option<HoodieInstant> currentTxnOwnerInstant = Option.empty();
    private Option<HoodieInstant> lastCompletedTxnOwnerInstant = Option.empty();

    public TransactionManager(HoodieWriteConfig config, FileSystem fs) {
        this.lockManager = new LockManager(config, fs);
        this.isOptimisticConcurrencyControlEnabled = config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl();
    }

    public void beginTransaction(Option<HoodieInstant> newTxnOwnerInstant, Option<HoodieInstant> lastCompletedTxnOwnerInstant) {
        if (this.isOptimisticConcurrencyControlEnabled) {
            LOG.info((Object)("Transaction starting for " + newTxnOwnerInstant + " with latest completed transaction instant " + lastCompletedTxnOwnerInstant));
            this.lockManager.lock();
            this.reset(this.currentTxnOwnerInstant, newTxnOwnerInstant, lastCompletedTxnOwnerInstant);
            LOG.info((Object)("Transaction started for " + newTxnOwnerInstant + " with latest completed transaction instant " + lastCompletedTxnOwnerInstant));
        }
    }

    public void endTransaction(Option<HoodieInstant> currentTxnOwnerInstant) {
        if (this.isOptimisticConcurrencyControlEnabled) {
            LOG.info((Object)("Transaction ending with transaction owner " + currentTxnOwnerInstant));
            if (this.reset(currentTxnOwnerInstant, (Option<HoodieInstant>)Option.empty(), (Option<HoodieInstant>)Option.empty())) {
                this.lockManager.unlock();
                LOG.info((Object)("Transaction ended with transaction owner " + currentTxnOwnerInstant));
            }
        }
    }

    private synchronized boolean reset(Option<HoodieInstant> callerInstant, Option<HoodieInstant> newTxnOwnerInstant, Option<HoodieInstant> lastCompletedTxnOwnerInstant) {
        if (!this.currentTxnOwnerInstant.isPresent() || ((HoodieInstant)this.currentTxnOwnerInstant.get()).equals(callerInstant.get())) {
            this.currentTxnOwnerInstant = newTxnOwnerInstant;
            this.lastCompletedTxnOwnerInstant = lastCompletedTxnOwnerInstant;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.isOptimisticConcurrencyControlEnabled) {
            this.lockManager.close();
            LOG.info((Object)"Transaction manager closed");
        }
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Option<HoodieInstant> getLastCompletedTransactionOwner() {
        return this.lastCompletedTxnOwnerInstant;
    }

    public Option<HoodieInstant> getCurrentTransactionOwner() {
        return this.currentTxnOwnerInstant;
    }

    public boolean isOptimisticConcurrencyControlEnabled() {
        return this.isOptimisticConcurrencyControlEnabled;
    }
}

